package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document;

public abstract class IndexQueryReport extends DocumentWriter<Resource>{

	protected Resource model;
	
	public IndexQueryReport() {
	}
	
	@Override
	public void start(ReadGraph graph, Resource model, Document writer, Map<Object, Object> context) throws Exception {
		super.start(graph, model, writer, context);
		this.model = model;
		
	}
	
	@Override
	public List<Resource> getReportItems(ReadGraph graph) throws DatabaseException {
		DocumentLink sl = DocumentLink.getInstance(graph);
		Instances instancesQuery = graph.adapt(sl.Source, Instances.class);
        Collection<Resource> found = instancesQuery.find(graph, model);
        List<Resource> list = new ArrayList<Resource>(found.size());
        list.addAll(found);
        found = null;
        sort(list);
        return list;
	}
	
	public abstract void sort(List<Resource> items) throws DatabaseException;
}
