package org.simantics.document.linking.report.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.objmap.graph.annotations.OrderedSetType;


@OrderedSetType(DocumentLink.URIs.EvaluatorTree_Root)
public class EvaluatorRoot extends EvaluatorNode{
	
	boolean supportMultiline = true;
	boolean supportStyles = false;
	
	public boolean isSupportMultiline() {
		return supportMultiline;
	}
	
	public void setSupportMultiline(boolean multilineSupport) {
		this.supportMultiline = multilineSupport;
	}
	
	public void setSupportStyles(boolean allowStyles) {
		this.supportStyles = allowStyles;
	}
	
	public boolean isSupportStyles() {
		return supportStyles;
	}
	
	@Override
	public String getValue(ReadGraph graph, Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (children.size() > 0 )
			return children.get(0).getValue(graph, variable, context);
		return null;
	}
	
	@Override
	public List<DocumentLine> getLines(ReadGraph graph,	Variable variable, Map<Object, Object> context) throws DatabaseException {
		if (children.size() > 0 )
			return children.get(0).getLines(graph, variable, context);
		return null;
	}
	
	@Override
	public List<Class<? extends EvaluatorItem>> getPossibleChildren(boolean add) {
		if (add && children.size() > 0)
			return Collections.emptyList();
		List<Class<? extends EvaluatorItem>> classes = super.getPossibleChildren(add);
		if (supportMultiline) {
			if (!(children.size() == 1 && children.get(0) instanceof Lines))
				classes.add(Lines.class);
		}
		return classes;
	}
	
	@Override
	public String toString() {
		return "root"; //$NON-NLS-1$
	}
	
	@Override
	public EvaluatorRoot getRoot() {
		return this;
	}
	
	@Override
	public EvaluatorItem copy() {
		EvaluatorRoot root = new EvaluatorRoot();
		root.supportMultiline = supportMultiline;
		root.supportStyles = supportStyles;
		copyChildren(root);
		return root;
	}
	
	@Override
	public ImageDescriptor getImage() {
		return null;
	}

}
