package org.simantics.document.linking.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.report.Document.TextSize;
import org.simantics.document.linking.report.TableColumn.Alignment;
import org.simantics.document.linking.report.templates.CustomizableContentProvider;
import org.simantics.document.linking.report.templates.ReportWriter;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;


public abstract class DocumentTitlePage implements DocumentElement{
	
	
	public void writeTitle(ReadGraph graph, Map<Object, Object> context) throws Exception {
		ReportWriter<?> reportWriter = (ReportWriter<?>)context.get(ReportWriter.class);
		CustomizableContent content = null;
		if (reportWriter instanceof CustomizableContentProvider) {
			content = ((CustomizableContentProvider)reportWriter).getContent("Title"); //$NON-NLS-1$
		}
		if (content == null)
			writeTitle(getDefaultLines(graph, (Resource)context.get("model"), (String)context.get("DocumentName"))); //$NON-NLS-1$ //$NON-NLS-2$
		else {
			
			List<DocumentLine> lines = content.getLines(graph, (Resource)context.get("model"), context); //$NON-NLS-1$
			writeTitle(lines);
		}
	}
	
	protected abstract void writeTitle(List<DocumentLine> lines) throws Exception;


	public List<DocumentLine> getDefaultLines(ReadGraph graph, Resource model, String documentName) throws DatabaseException{
		List<DocumentLine> result = new ArrayList<DocumentLine>();
		
		String modelName = NameUtils.getSafeLabel(graph, model);
		if (modelName.length() == 0)
			modelName = NameUtils.getSafeName(graph, model);
		
		java.util.Date date = new java.util.Date(System.currentTimeMillis());
		String dateString = DateFormat.getDateTimeInstance().format(date);
	
		result.add(new DocumentLine(modelName, Alignment.class, Alignment.CENTER, TextSize.class, TextSize.HUGE));
		result.add(new DocumentLine(documentName, Alignment.class, Alignment.CENTER, TextSize.class, TextSize.HUGE));
		result.add(new DocumentLine(dateString, Alignment.class, Alignment.CENTER, TextSize.class, TextSize.LARGE));
		
		return result;
	}
	
	

}
