package org.simantics.document.linking.ge;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class VariableInstanceOfTest  implements Test  {
	Resource type;
	
	public VariableInstanceOfTest(Resource type) {
		this.type = type;
	}
	
	
	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType == Variable.class;
	}
	
	@Override
	public boolean test(ReadGraph graph, Object content)
			throws DatabaseException {
		Variable variable = (Variable)content;
		Resource res = variable.getPossibleRepresents(graph);
		if (res == null)
			return false;
		return graph.isInstanceOf(res, type);
	}
	

}
