/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.ui.IMemento;
import org.simantics.utils.ui.workbench.StringMemento;

/**
 * @author Antti Villberg
 */
public final class CSVExportPreferences {

    public static final String  RECENT_LOCATIONS = "RECENT_CSV_EXPORT_LOCATIONS";
    public static final String  EXPORT_OVERWRITE = "CSV_EXPORT_OVERWRITE";

    private static final String TAG_PATH                = "path";
    private static final String ATTR_NAME               = "name";

    public static Deque<String> decodePaths(String recentPathsPref) {
        Deque<String> result = new LinkedList<String>();
        try {
            StringMemento sm = new StringMemento(recentPathsPref);
            for (IMemento m : sm.getChildren(TAG_PATH)) {
                String name = m.getString(ATTR_NAME);
                if (name != null && !name.isEmpty())
                    result.add(name);
            }
        } catch (IllegalArgumentException e) {
        }
        return result;
    }

    public static String encodePaths(Deque<String> recentPaths) {
        StringMemento sm = new StringMemento();
        for (String path : recentPaths) {
            IMemento m = sm.createChild(TAG_PATH);
            m.putString(ATTR_NAME, path);
        }
        return sm.toString();
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        // Remove duplicates
        Set<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Iterator<String> it = iter.iterator(); it.hasNext();) {
            String path = it.next();
            if (!dups.add(path)) {
                it.remove();
            }
        }
    }

}
