/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.editor;

import java.util.UUID;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;

/**
 * 
 * @author Antti Villberg
 */
public class ActiveRunQuery extends BinaryRead<UUID, Resource, Resource> {

    public ActiveRunQuery(UUID id, Resource resource) {
        super(id, resource);
    }

    @Override
    public Resource perform(ReadGraph graph) throws DatabaseException {
    	return graph.syncRequest(new PossibleActiveExperiment(parameter2));
    }

}