/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.v30.MessageDecoder;
import com.impossibl.postgres.protocol.v30.MessageHandler;
import com.impossibl.postgres.protocol.v30.NamedThreadFactory;
import com.impossibl.postgres.system.Context;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.ThreadDeathWatcher;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ProtocolShared {
    static ProtocolShared instance;
    private Bootstrap bootstrap;
    private int count = 0;

    public static synchronized Ref acquire(Context context) {
        if (instance == null) {
            instance = new ProtocolShared();
        }
        return instance.addReference(context);
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    private synchronized Ref addReference(Context context) {
        if (this.count == 0) {
            this.init(context);
        }
        ++this.count;
        return new Ref();
    }

    private synchronized void release() {
        if (this.count == 1) {
            this.shutdown();
            this.count = 0;
        } else {
            --this.count;
        }
    }

    private void init(Context context) {
        PooledByteBufAllocator allocator = null;
        switch (System.getProperty("com.impossibl.netty.bytebuf.allocator", "pooled")) {
            case "pooled": {
                allocator = PooledByteBufAllocator.DEFAULT;
                break;
            }
            case "unpooled": {
                allocator = UnpooledByteBufAllocator.DEFAULT;
            }
        }
        int workerCount = Runtime.getRuntime().availableProcessors();
        NioEventLoopGroup group = new NioEventLoopGroup(workerCount, (ThreadFactory)new NamedThreadFactory("PG-JDBC EventLoop"));
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new MessageDecoder(), new MessageHandler()});
            }
        })).option(ChannelOption.ALLOCATOR, (Object)allocator);
        if (context != null) {
            if (context.getSetting("receiveBufferSize", -1) != -1) {
                this.bootstrap.option(ChannelOption.SO_RCVBUF, context.getSetting("receiveBufferSize", Integer.TYPE));
            }
            if (context.getSetting("sendBufferSize", -1) != -1) {
                this.bootstrap.option(ChannelOption.SO_SNDBUF, context.getSetting("sendBufferSize", Integer.TYPE));
            }
        }
    }

    public Future<?> shutdown() {
        return this.bootstrap.group().shutdownGracefully(10L, 100L, TimeUnit.MILLISECONDS);
    }

    public void waitForShutdown() {
        this.shutdown().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        Thread deathThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadDeathWatcher.awaitInactivity((long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        Thread globalThread = new Thread(){

            @Override
            public void run() {
                try {
                    GlobalEventExecutor.INSTANCE.awaitInactivity(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        try {
            globalThread.join(TimeUnit.SECONDS.toMillis(5L));
            deathThread.join(TimeUnit.SECONDS.toMillis(5L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class Ref {
        private boolean released;

        public ProtocolShared get() {
            return ProtocolShared.this;
        }

        public void release() {
            if (!this.released) {
                this.released = true;
                ProtocolShared.this.release();
            }
        }
    }
}

