/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.CloseCommand;
import com.impossibl.postgres.protocol.Command;
import com.impossibl.postgres.protocol.FunctionCallCommand;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.PrepareCommand;
import com.impossibl.postgres.protocol.Protocol;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.SSLRequestCommand;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.StartupCommand;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.BindExecCommandImpl;
import com.impossibl.postgres.protocol.v30.CloseCommandImpl;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.FunctionCallCommandImpl;
import com.impossibl.postgres.protocol.v30.PrepareCommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolListener;
import com.impossibl.postgres.protocol.v30.ProtocolShared;
import com.impossibl.postgres.protocol.v30.QueryCommandImpl;
import com.impossibl.postgres.protocol.v30.ResponseMessage;
import com.impossibl.postgres.protocol.v30.SSLRequestCommandImpl;
import com.impossibl.postgres.protocol.v30.StartupCommandImpl;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.ByteBufs;
import com.impossibl.postgres.utils.guava.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtocolImpl
implements Protocol {
    private static final AttributeKey<ProtocolImpl> PROTOCOL_KEY = AttributeKey.valueOf((String)"protocol");
    private static Logger logger = Logger.getLogger(ProtocolImpl.class.getName());
    private static final byte PASSWORD_MSG_ID = 112;
    private static final byte FLUSH_MSG_ID = 72;
    private static final byte TERMINATE_MSG_ID = 88;
    private static final byte SYNC_MSG_ID = 83;
    private static final byte QUERY_MSG_ID = 81;
    private static final byte PARSE_MSG_ID = 80;
    private static final byte BIND_MSG_ID = 66;
    private static final byte DESCRIBE_MSG_ID = 68;
    private static final byte EXECUTE_MSG_ID = 69;
    private static final byte CLOSE_MSG_ID = 67;
    private static final byte FUNCTION_CALL_MSG_ID = 70;
    private static final byte BACKEND_KEY_MSG_ID = 75;
    private static final byte AUTHENTICATION_MSG_ID = 82;
    private static final byte ERROR_MSG_ID = 69;
    private static final byte NOTICE_MSG_ID = 78;
    private static final byte NOTIFICATION_MSG_ID = 65;
    private static final byte COMMAND_COMPLETE_MSG_ID = 67;
    private static final byte PARAMETER_STATUS_MSG_ID = 83;
    private static final byte READY_FOR_QUERY_MSG_ID = 90;
    private static final byte PARAMETER_DESC_MSG_ID = 116;
    private static final byte ROW_DESC_MSG_ID = 84;
    private static final byte ROW_DATA_MSG_ID = 68;
    private static final byte PORTAL_SUSPENDED_MSG_ID = 115;
    private static final byte NO_DATA_MSG_ID = 110;
    private static final byte EMPTY_QUERY_MSG_ID = 73;
    private static final byte PARSE_COMPLETE_MSG_ID = 49;
    private static final byte BIND_COMPLETE_MSG_ID = 50;
    private static final byte CLOSE_COMPLETE_MSG_ID = 51;
    private static final byte FUNCTION_RESULT_MSG_ID = 86;
    private final ProtocolListener nullListener = new BaseProtocolListener(){

        @Override
        public void exception(Throwable cause) throws IOException {
            ProtocolImpl.this.lastException = cause;
        }
    };
    private final InetSocketAddress remote;
    AtomicBoolean connected = new AtomicBoolean(true);
    ProtocolShared.Ref sharedRef;
    Channel channel;
    WeakReference<BasicContext> contextRef;
    TransactionStatus txStatus;
    ProtocolListener listener;
    ScheduledFuture<?> executionTimeout;
    ExecutionTimerTask task;
    Throwable lastException;

    private ProtocolImpl(ProtocolShared.Ref sharedRef, Channel channel, BasicContext context) {
        this.sharedRef = sharedRef;
        this.channel = channel;
        this.contextRef = new WeakReference<BasicContext>(context);
        this.txStatus = TransactionStatus.Idle;
        this.remote = (InetSocketAddress)channel.remoteAddress();
    }

    public BasicContext getContext() {
        return (BasicContext)this.contextRef.get();
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public boolean isConnected() {
        return this.connected.get() && this.channel.isActive();
    }

    @Override
    public void shutdown() {
        if (!this.connected.getAndSet(false)) {
            return;
        }
        try {
            ByteBuf msg = this.channel.alloc().buffer();
            this.writeTerminate(msg);
            this.channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Exception e) {
            this.channel.close().awaitUninterruptibly(100L);
        }
        this.sharedRef.release();
    }

    private void kill() {
        this.connected.set(false);
        this.channel.close().awaitUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(Executor executor) {
        ProtocolListener localListener;
        if (!this.connected.get()) {
            return;
        }
        this.shutdown();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ProtocolImpl.this.sendCancelRequest();
            }
        });
        ProtocolListener protocolListener = localListener = this.listener;
        synchronized (protocolListener) {
            localListener.abort();
            localListener.notifyAll();
        }
    }

    void setListener(ProtocolListener listener) {
        this.listener = listener;
    }

    @Override
    public SSLRequestCommand createSSLRequest() {
        return new SSLRequestCommandImpl();
    }

    @Override
    public StartupCommand createStartup(Map<String, Object> settings) {
        return new StartupCommandImpl(settings);
    }

    @Override
    public PrepareCommand createPrepare(String statementName, String sqlText, List<Type> parameterTypes) {
        return new PrepareCommandImpl(statementName, sqlText, parameterTypes);
    }

    @Override
    public BindExecCommand createBindExec(String portalName, String statementName, List<Type> parameterTypes, List<Object> parameterValues, List<ResultField> resultFields) {
        return new BindExecCommandImpl(portalName, statementName, parameterTypes, parameterValues, resultFields);
    }

    @Override
    public QueryCommand createQuery(String sqlText) {
        return new QueryCommandImpl(sqlText);
    }

    @Override
    public FunctionCallCommand createFunctionCall(String functionName, List<Type> parameterTypes, List<Object> parameterValues) {
        return new FunctionCallCommandImpl(functionName, parameterTypes, parameterValues);
    }

    @Override
    public CloseCommand createClose(ServerObjectType objectType, String objectName) {
        return new CloseCommandImpl(objectType, objectName);
    }

    public void enableExecutionTimer(ExecutionTimerTask task, long timeout) {
        if (this.executionTimeout != null) {
            throw new IllegalStateException("execution timer already enabled");
        }
        this.task = task;
        this.executionTimeout = this.channel.eventLoop().schedule((Callable)task, timeout, TimeUnit.MILLISECONDS);
    }

    public void cancelExecutionTimer() {
        if (this.executionTimeout != null) {
            try {
                this.executionTimeout.cancel(true);
                this.task.cancel();
            }
            finally {
                this.task = null;
                this.executionTimeout = null;
            }
        }
    }

    @Override
    public synchronized void execute(Command cmd) throws IOException {
        this.lastException = null;
        if (!(cmd instanceof CommandImpl)) {
            throw new IllegalArgumentException();
        }
        if (!this.connected.get() || !this.channel.isActive()) {
            throw new InterruptedIOException("channel closed");
        }
        try {
            ((CommandImpl)cmd).execute(this);
            Throwable exception = cmd.getException();
            if (exception != null) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(exception.getCause());
            }
            if (cmd.getError() != null && cmd.getError().getCode().startsWith("08")) {
                this.kill();
            }
        }
        catch (InterruptedIOException e) {
            this.sendCancelRequest();
            throw e;
        }
        finally {
            this.cancelExecutionTimer();
            this.listener = this.nullListener;
        }
    }

    @Override
    public TransactionStatus getTransactionStatus() {
        return this.txStatus;
    }

    public void writeSSLRequest(ByteBuf msg) throws IOException {
        msg.writeInt(8);
        msg.writeInt(80877103);
    }

    public void writeStartup(ByteBuf msg, Map<String, Object> params) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("STARTUP: " + params);
        }
        this.beginMessage(msg, (byte)0);
        msg.writeShort(3);
        msg.writeShort(0);
        for (Map.Entry<String, Object> paramEntry : params.entrySet()) {
            ByteBufs.writeCString(msg, paramEntry.getKey(), context.getCharset());
            ByteBufs.writeCString(msg, paramEntry.getValue().toString(), context.getCharset());
        }
        msg.writeByte(0);
        this.endMessage(msg);
    }

    public void writePassword(ByteBuf msg, String password) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("PASSWORD: " + password);
        }
        this.beginMessage(msg, (byte)112);
        ByteBufs.writeCString(msg, password, context.getCharset());
        this.endMessage(msg);
    }

    public void writeQuery(ByteBuf msg, String query) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("QUERY: " + query);
        }
        this.beginMessage(msg, (byte)81);
        ByteBufs.writeCString(msg, query, context.getCharset());
        this.endMessage(msg);
    }

    public void writeParse(ByteBuf msg, String stmtName, String query, List<Type> paramTypes) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("PARSE (" + stmtName + "): " + query);
        }
        this.beginMessage(msg, (byte)80);
        ByteBufs.writeCString(msg, stmtName != null ? stmtName : "", context.getCharset());
        ByteBufs.writeCString(msg, query, context.getCharset());
        msg.writeShort(paramTypes.size());
        for (Type paramType : paramTypes) {
            int paramTypeOid = paramType != null ? paramType.getId() : 0;
            msg.writeInt(paramTypeOid);
        }
        this.endMessage(msg);
    }

    public void writeBind(ByteBuf msg, String portalName, String stmtName, List<Type> parameterTypes, List<Object> parameterValues, List<ResultField.Format> resultFieldFormats) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("BIND (" + portalName + "): " + parameterValues.size());
        }
        byte[] portalNameBytes = Strings.nullToEmpty(portalName).getBytes(context.getCharset());
        byte[] stmtNameBytes = Strings.nullToEmpty(stmtName).getBytes(context.getCharset());
        this.beginMessage(msg, (byte)66);
        this.writeBind(msg, portalNameBytes, stmtNameBytes, parameterTypes, parameterValues, resultFieldFormats, context);
        this.endMessage(msg);
    }

    private void writeBind(ByteBuf msg, byte[] portalNameBytes, byte[] stmtNameBytes, List<Type> parameterTypes, List<Object> parameterValues, List<ResultField.Format> resultFieldFormats, Context context) throws IOException {
        ByteBufs.writeCString(msg, portalNameBytes);
        ByteBufs.writeCString(msg, stmtNameBytes);
        this.loadParams(msg, parameterTypes, parameterValues, context);
        if (resultFieldFormats.isEmpty()) {
            msg.writeShort(1);
            msg.writeShort(1);
        } else {
            msg.writeShort(resultFieldFormats.size());
            for (ResultField.Format format : resultFieldFormats) {
                msg.writeShort(format.ordinal());
            }
        }
    }

    public void writeDescribe(ByteBuf msg, ServerObjectType target, String targetName) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DESCRIBE " + (Object)((Object)target) + " (" + targetName + ")");
        }
        this.beginMessage(msg, (byte)68);
        msg.writeByte((int)target.getId());
        ByteBufs.writeCString(msg, targetName != null ? targetName : "", context.getCharset());
        this.endMessage(msg);
    }

    public void writeExecute(ByteBuf msg, String portalName, int maxRows) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("EXECUTE (" + portalName + "): " + maxRows);
        }
        this.beginMessage(msg, (byte)69);
        ByteBufs.writeCString(msg, portalName != null ? portalName : "", context.getCharset());
        msg.writeInt(maxRows);
        this.endMessage(msg);
    }

    public void writeFunctionCall(ByteBuf msg, int functionId, List<Type> paramTypes, List<Object> paramValues) throws IOException {
        BasicContext context = this.getContext();
        this.beginMessage(msg, (byte)70);
        msg.writeInt(functionId);
        this.loadParams(msg, paramTypes, paramValues, context);
        msg.writeShort(1);
        this.endMessage(msg);
    }

    public void writeClose(ByteBuf msg, ServerObjectType target, String targetName) throws IOException {
        BasicContext context = this.getContext();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("CLOSE " + (Object)((Object)target) + ": " + targetName);
        }
        this.beginMessage(msg, (byte)67);
        msg.writeByte((int)target.getId());
        ByteBufs.writeCString(msg, targetName != null ? targetName : "", context.getCharset());
        this.endMessage(msg);
    }

    public void writeFlush(ByteBuf msg) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("FLUSH");
        }
        this.writeMessage(msg, (byte)72);
    }

    public void writeSync(ByteBuf msg) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SYNC");
        }
        this.writeMessage(msg, (byte)83);
    }

    public void writeTerminate(ByteBuf msg) throws IOException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("TERM");
        }
        this.writeMessage(msg, (byte)88);
    }

    public void send(ByteBuf msg) throws IOException {
        this.channel.writeAndFlush((Object)msg);
    }

    void sendCancelRequest() {
        BasicContext context = this.getContext();
        logger.finer("CANCEL");
        Context.KeyData keyData = context.getKeyData();
        logger.finest("OPEN-SOCKET");
        try (Socket abortSocket = new Socket(this.remote.getAddress(), this.remote.getPort());){
            logger.finest("SEND-DATA");
            DataOutputStream os = new DataOutputStream(abortSocket.getOutputStream());
            os.writeInt(16);
            os.writeInt(80877102);
            os.writeInt(keyData.getProcessId());
            os.writeInt(keyData.getSecretKey());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void loadParams(ByteBuf buffer, List<Type> paramTypes, List<Object> paramValues, Context context) throws IOException {
        if (paramTypes == null) {
            buffer.writeShort(1);
            buffer.writeShort(1);
        } else {
            buffer.writeShort(paramTypes.size());
            for (Type paramType : paramTypes) {
                buffer.writeShort(paramType.getParameterFormat().ordinal());
            }
        }
        if (paramTypes == null) {
            buffer.writeShort(0);
        } else {
            buffer.writeShort(paramTypes.size());
            for (int c = 0; c < paramTypes.size(); ++c) {
                Type paramType;
                paramType = paramTypes.get(c);
                Object paramValue = paramValues.get(c);
                Type.Codec codec = paramType.getCodec(paramType.getParameterFormat());
                codec.getEncoder().encode(paramType, buffer, paramValue, context);
            }
        }
    }

    protected void writeMessage(ByteBuf msg, byte msgId) throws IOException {
        msg.writeByte((int)msgId);
        msg.writeInt(4);
    }

    protected void beginMessage(ByteBuf msg, byte msgId) {
        this.beginMessage(msg, msgId, -1);
    }

    protected void beginMessage(ByteBuf msg, byte msgId, int length) {
        if (msgId != 0) {
            msg.writeByte((int)msgId);
        }
        msg.markWriterIndex();
        msg.writeInt(length);
    }

    protected void endMessage(ByteBuf msg) throws IOException {
        int endPos = msg.writerIndex();
        msg.resetWriterIndex();
        int begPos = msg.writerIndex();
        msg.setInt(begPos, endPos - begPos);
        msg.writerIndex(endPos);
    }

    public void dispatch(ResponseMessage msg) throws IOException {
        switch (msg.getId()) {
            case 82: {
                this.receiveAuthentication(msg.getData());
                break;
            }
            case 75: {
                this.receiveBackendKeyData(msg.getData());
                break;
            }
            case 116: {
                this.receiveParameterDescriptions(msg.getData());
                break;
            }
            case 84: {
                this.receiveRowDescription(msg.getData());
                break;
            }
            case 68: {
                this.receiveRowData(msg.getData());
                break;
            }
            case 115: {
                this.receivePortalSuspended(msg.getData());
                break;
            }
            case 110: {
                this.receiveNoData(msg.getData());
                break;
            }
            case 49: {
                this.receiveParseComplete(msg.getData());
                break;
            }
            case 50: {
                this.receiveBindComplete(msg.getData());
                break;
            }
            case 51: {
                this.receiveCloseComplete(msg.getData());
                break;
            }
            case 73: {
                this.receiveEmptyQuery(msg.getData());
                break;
            }
            case 86: {
                this.receiveFunctionResult(msg.getData());
                break;
            }
            case 69: {
                this.receiveError(msg.getData());
                break;
            }
            case 78: {
                this.receiveNotice(msg.getData());
                break;
            }
            case 65: {
                this.receiveNotification(msg.getData());
                break;
            }
            case 67: {
                this.receiveCommandComplete(msg.getData());
                break;
            }
            case 83: {
                this.receiveParameterStatus(msg.getData());
                break;
            }
            case 90: {
                this.receiveReadyForQuery(msg.getData());
                break;
            }
            default: {
                logger.fine("unsupported message type: " + (msg.getId() & 0xFF));
            }
        }
    }

    public void dispatchException(Throwable cause) throws IOException {
        if (this.listener != null) {
            this.listener.exception(cause);
        }
    }

    private void receiveAuthentication(ByteBuf buffer) throws IOException {
        int code = buffer.readInt();
        switch (code) {
            case 0: {
                this.listener.authenticated(this);
                return;
            }
            case 2: {
                this.listener.authenticateKerberos(this);
                break;
            }
            case 3: {
                this.listener.authenticateClear(this);
                return;
            }
            case 4: {
                this.listener.authenticateCrypt(this);
                return;
            }
            case 5: {
                byte[] salt = new byte[4];
                buffer.readBytes(salt);
                this.listener.authenticateMD5(this, salt);
                return;
            }
            case 6: {
                this.listener.authenticateSCM(this);
                break;
            }
            case 7: {
                this.listener.authenticateGSS(this);
                break;
            }
            case 8: {
                this.listener.authenticateGSSCont(this);
                break;
            }
            case 9: {
                this.listener.authenticateSSPI(this);
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid authentication type");
            }
        }
    }

    private void receiveBackendKeyData(ByteBuf buffer) throws IOException {
        int processId = buffer.readInt();
        int secretKey = buffer.readInt();
        this.listener.backendKeyData(processId, secretKey);
    }

    private void receiveError(ByteBuf buffer) throws IOException {
        Notice notice = this.parseNotice(buffer);
        logger.finest("ERROR: " + notice.getCode() + ": " + notice.getMessage());
        this.listener.error(notice);
    }

    private void receiveNotice(ByteBuf buffer) throws IOException {
        Notice notice = this.parseNotice(buffer);
        logger.finest(notice.getSeverity() + ": " + notice.getCode() + ": " + notice.getMessage());
        this.listener.notice(notice);
    }

    private void receiveParameterDescriptions(ByteBuf buffer) throws IOException {
        BasicContext context = this.getContext();
        int paramCount = buffer.readUnsignedShort();
        TypeRef[] paramTypes = new TypeRef[paramCount];
        for (int c = 0; c < paramCount; ++c) {
            int paramTypeId = buffer.readInt();
            paramTypes[c] = TypeRef.from(paramTypeId, context.getRegistry());
        }
        logger.finest("PARAM-DESC: " + paramCount);
        this.listener.parametersDescription(Arrays.asList(paramTypes));
    }

    private void receiveRowDescription(ByteBuf buffer) throws IOException {
        BasicContext context = this.getContext();
        Registry registry = context.getRegistry();
        int fieldCount = buffer.readUnsignedShort();
        ArrayList<ResultField> fields = new ArrayList<ResultField>(fieldCount);
        for (int c = 0; c < fieldCount; ++c) {
            ResultField field = new ResultField(ByteBufs.readCString(buffer, context.getCharset()), buffer.readInt(), (short)buffer.readUnsignedShort(), TypeRef.from(buffer.readInt(), registry), buffer.readShort(), buffer.readInt(), ResultField.Format.values()[buffer.readUnsignedShort()]);
            fields.add(field);
        }
        logger.finest("ROW-DESC: " + fieldCount);
        this.listener.rowDescription(fields);
    }

    private void receiveRowData(ByteBuf buffer) throws IOException {
        logger.finest("DATA");
        this.listener.rowData(buffer);
    }

    private void receivePortalSuspended(ByteBuf buffer) throws IOException {
        logger.finest("SUSPEND");
        this.listener.portalSuspended();
    }

    private void receiveNoData(ByteBuf buffer) throws IOException {
        logger.finest("NO-DATA");
        this.listener.noData();
    }

    private void receiveCloseComplete(ByteBuf buffer) throws IOException {
        logger.finest("CLOSE-COMP");
        this.listener.closeComplete();
    }

    private void receiveBindComplete(ByteBuf buffer) throws IOException {
        logger.finest("BIND-COMP");
        this.listener.bindComplete();
    }

    private void receiveParseComplete(ByteBuf buffer) throws IOException {
        logger.finest("PARSE-COMP");
        this.listener.parseComplete();
    }

    private void receiveEmptyQuery(ByteBuf buffer) throws IOException {
        logger.finest("EMPTY");
        this.listener.emptyQuery();
    }

    private void receiveFunctionResult(ByteBuf buffer) throws IOException {
        logger.finest("FUNCTION-RES");
        this.listener.functionResult(buffer);
    }

    private void receiveCommandComplete(ByteBuf buffer) throws IOException {
        BasicContext context = this.getContext();
        String commandTag = ByteBufs.readCString(buffer, context.getCharset());
        Object[] parts = commandTag.split(" ");
        String command = parts[0];
        Long rowsAffected = null;
        Long oid = null;
        switch (command) {
            case "INSERT": {
                if (parts.length == 3) {
                    oid = Long.parseLong(parts[1]);
                    rowsAffected = Long.parseLong(parts[2]);
                    break;
                }
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "SELECT": {
                if (parts.length == 2) {
                    rowsAffected = null;
                    break;
                }
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "UPDATE": 
            case "DELETE": 
            case "MOVE": 
            case "FETCH": {
                if (parts.length == 2) {
                    rowsAffected = Long.parseLong(parts[1]);
                    break;
                }
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "COPY": {
                if (parts.length == 1) break;
                if (parts.length == 2) {
                    rowsAffected = Long.parseLong(parts[1]);
                    break;
                }
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "CREATE": 
            case "DROP": 
            case "ALTER": 
            case "DECLARE": 
            case "CLOSE": {
                if (parts.length == 2) {
                    command = command + " " + parts[1];
                    rowsAffected = 0L;
                    break;
                }
                if (parts.length == 3) {
                    command = command + " " + (String)parts[1] + " " + (String)parts[2];
                    rowsAffected = 0L;
                    break;
                }
                if (parts.length == 4) {
                    command = command + " " + (String)parts[1] + " " + (String)parts[2] + " " + (String)parts[3];
                    rowsAffected = 0L;
                    break;
                }
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "PREPARE": {
                if (parts.length == 2) break;
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "COMMIT": {
                if (parts.length == 1 || parts.length == 2) break;
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "ROLLBACK": {
                if (parts.length == 1 || parts.length == 2) break;
                throw new IOException("error parsing command tag: " + command + " (" + Arrays.toString(parts) + ")");
            }
            case "DEALLOCATE": 
            case "TRUNCATE": 
            case "LOCK": 
            case "GRANT": 
            case "REVOKE": {
                break;
            }
            default: {
                if (parts.length > 1) {
                    logger.warning("Ignoring unknown complex command tag: " + command + " (" + Arrays.toString(parts) + ")");
                }
                rowsAffected = 0L;
            }
        }
        logger.finest("COMPLETE: " + commandTag);
        this.listener.commandComplete(command, rowsAffected, oid);
    }

    protected void receiveNotification(ByteBuf buffer) throws IOException {
        BasicContext context = this.getContext();
        int processId = buffer.readInt();
        String channelName = ByteBufs.readCString(buffer, context.getCharset());
        String payload = ByteBufs.readCString(buffer, context.getCharset());
        logger.finest("NOTIFY: " + processId + " - " + channelName + " - " + payload);
        this.listener.notification(processId, channelName, payload);
        context.reportNotification(processId, channelName, payload);
    }

    private void receiveParameterStatus(ByteBuf buffer) throws IOException {
        BasicContext context = this.getContext();
        String name = ByteBufs.readCString(buffer, context.getCharset());
        String value = ByteBufs.readCString(buffer, context.getCharset());
        context.updateSystemParameter(name, value);
    }

    private void receiveReadyForQuery(ByteBuf buffer) throws IOException {
        switch (buffer.readByte()) {
            case 84: {
                this.txStatus = TransactionStatus.Active;
                break;
            }
            case 69: {
                this.txStatus = TransactionStatus.Failed;
                break;
            }
            case 73: {
                this.txStatus = TransactionStatus.Idle;
                break;
            }
            default: {
                throw new IllegalStateException("invalid transaction status");
            }
        }
        logger.finest("READY: " + (Object)((Object)this.txStatus));
        this.listener.ready(this.txStatus);
    }

    private Notice parseNotice(ByteBuf buffer) {
        byte msgId;
        BasicContext context = this.getContext();
        Notice notice = new Notice();
        block17: while ((msgId = buffer.readByte()) != 0) {
            switch (msgId) {
                case 83: {
                    notice.setSeverity(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 67: {
                    notice.setCode(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 77: {
                    notice.setMessage(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 68: {
                    notice.setDetail(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 72: {
                    notice.setHint(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 80: {
                    notice.setPosition(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 87: {
                    notice.setWhere(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 70: {
                    notice.setFile(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 76: {
                    notice.setLine(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 82: {
                    notice.setRoutine(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 115: {
                    notice.setSchema(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 116: {
                    notice.setTable(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 99: {
                    notice.setColumn(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 100: {
                    notice.setDatatype(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
                case 110: {
                    notice.setConstraint(ByteBufs.readCString(buffer, context.getCharset()));
                    continue block17;
                }
            }
            ByteBufs.readCString(buffer, context.getCharset());
        }
        return notice;
    }

    static ProtocolImpl getAttached(Channel channel) {
        return (ProtocolImpl)channel.attr(PROTOCOL_KEY).get();
    }

    static ProtocolImpl newInstance(ProtocolShared.Ref sharedRef, Channel channel, BasicContext context) {
        ProtocolImpl impl = new ProtocolImpl(sharedRef, channel, context);
        channel.attr(PROTOCOL_KEY).set((Object)impl);
        return impl;
    }

    public static abstract class ExecutionTimerTask
    implements Callable<Void> {
        private AtomicReference<State> state = new AtomicReference<State>(State.NotStarted);
        private Thread thread;

        public abstract void run();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                this.thread = Thread.currentThread();
                if (!this.state.compareAndSet(State.NotStarted, State.Running)) {
                    Void void_ = null;
                    return void_;
                }
                this.run();
            }
            catch (Throwable throwable) {
                this.state.set(State.Completed);
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    this.state.notify();
                }
            }
            finally {
                this.state.set(State.Completed);
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    this.state.notify();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel() {
            if (this.state.getAndSet(State.Cancelling) == State.Running) {
                this.thread.interrupt();
                AtomicReference<State> atomicReference = this.state;
                synchronized (atomicReference) {
                    while (this.state.get() == State.Cancelling) {
                        try {
                            this.state.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        static enum State {
            NotStarted,
            Running,
            Cancelling,
            Completed;

        }
    }
}

