/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.data.Interval;
import com.impossibl.postgres.api.data.Record;
import com.impossibl.postgres.api.data.Tid;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.Instants;
import com.impossibl.postgres.jdbc.ArrayUtils;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGClob;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.PGRowId;
import com.impossibl.postgres.jdbc.PGSQLInputImpl;
import com.impossibl.postgres.jdbc.PGSQLOutputImpl;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.jdbc.PGStruct;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.guava.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

class SQLTypeUtils {
    SQLTypeUtils() {
    }

    public static Class<?> mapSetType(Type sourceType) {
        return SQLTypeUtils.mapSetType(sourceType.getPreferredFormat(), sourceType);
    }

    public static Class<?> mapSetType(ResultField.Format format, Type sourceType) {
        return sourceType.getJavaType(format, null);
    }

    public static Class<?> mapGetType(Type sourceType, Map<String, Class<?>> typeMap, Context context) {
        return SQLTypeUtils.mapGetType(sourceType.getPreferredFormat(), sourceType, typeMap, context);
    }

    public static Class<?> mapGetType(ResultField.Format format, Type sourceType, Map<String, Class<?>> typeMap, Context context) {
        Class targetType;
        switch (sourceType.getPrimitiveType()) {
            case Date: {
                targetType = Date.class;
                break;
            }
            case Time: 
            case TimeTZ: {
                targetType = Time.class;
                break;
            }
            case Timestamp: 
            case TimestampTZ: {
                targetType = Timestamp.class;
                break;
            }
            case Record: {
                targetType = sourceType.getJavaType(format, typeMap);
                targetType = SQLData.class.isAssignableFrom(targetType) ? targetType : Struct.class;
                break;
            }
            case Tid: {
                targetType = RowId.class;
                break;
            }
            case XML: {
                targetType = SQLXML.class;
                break;
            }
            case Array: {
                ArrayType arrayType = (ArrayType)sourceType;
                targetType = Array.newInstance(SQLTypeUtils.mapGetType(format, arrayType.getElementType(), typeMap, context), 0).getClass();
                break;
            }
            case Oid: {
                if (sourceType.getName().equals(context.getSetting("blob.type", "blobid"))) {
                    targetType = Blob.class;
                    break;
                }
                if (sourceType.getName().equals(context.getSetting("clob.type", "clobid"))) {
                    targetType = Clob.class;
                    break;
                }
            }
            default: {
                targetType = sourceType.getJavaType(format, typeMap);
            }
        }
        return targetType;
    }

    public static Object coerce(Object val, Type sourceType, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        return SQLTypeUtils.coerce(sourceType.getPreferredFormat(), val, sourceType, targetType, typeMap, connection);
    }

    public static Object coerce(ResultField.Format format, Object val, Type sourceType, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        return SQLTypeUtils.coerce(format, val, sourceType, targetType, typeMap, TimeZone.getDefault(), connection);
    }

    public static Object coerce(Object val, Type sourceType, Class<?> targetType, Map<String, Class<?>> typeMap, TimeZone zone, PGConnectionImpl connection) throws SQLException {
        return SQLTypeUtils.coerce(sourceType.getPreferredFormat(), val, sourceType, targetType, typeMap, zone, connection);
    }

    public static Object coerce(ResultField.Format format, Object val, Type sourceType, Class<?> targetType, Map<String, Class<?>> typeMap, TimeZone zone, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (targetType.isInstance(val)) {
            return val;
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return SQLTypeUtils.coerceToByte(val);
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return SQLTypeUtils.coerceToShort(val);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return SQLTypeUtils.coerceToInt(val);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return SQLTypeUtils.coerceToLong(val);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(SQLTypeUtils.coerceToFloat(val));
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return SQLTypeUtils.coerceToDouble(val);
        }
        if (targetType == BigDecimal.class) {
            return SQLTypeUtils.coerceToBigDecimal(val);
        }
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return SQLTypeUtils.coerceToBoolean(val);
        }
        if (targetType == String.class) {
            return SQLTypeUtils.coerceToString(val, sourceType, connection);
        }
        if (targetType == Date.class) {
            return SQLTypeUtils.coerceToDate(val, zone, connection);
        }
        if (targetType == Time.class) {
            return SQLTypeUtils.coerceToTime(val, zone, connection);
        }
        if (targetType == Timestamp.class) {
            return SQLTypeUtils.coerceToTimestamp(val, zone, connection);
        }
        if (targetType == Instant.class) {
            return SQLTypeUtils.coerceToInstant(val, sourceType, zone, connection);
        }
        if (targetType == Interval.class) {
            return SQLTypeUtils.coerceToInterval(val);
        }
        if (targetType == URL.class) {
            return SQLTypeUtils.coerceToURL(val);
        }
        if (targetType == Blob.class) {
            return SQLTypeUtils.coerceToBlob(val, connection);
        }
        if (targetType == Clob.class) {
            return SQLTypeUtils.coerceToClob(val, connection);
        }
        if (targetType == RowId.class) {
            return SQLTypeUtils.coerceToRowId(val, sourceType);
        }
        if (targetType == Tid.class) {
            return SQLTypeUtils.coerceToTid(val);
        }
        if (InputStream.class.isAssignableFrom(targetType)) {
            return SQLTypeUtils.coerceToByteStream(format, val, sourceType, connection);
        }
        if (targetType == byte[].class || targetType == Byte[].class) {
            return SQLTypeUtils.coerceToBytes(format, val, sourceType, connection);
        }
        if (targetType.isArray()) {
            return SQLTypeUtils.coerceToArray(format, val, sourceType, targetType, typeMap, connection);
        }
        if (targetType == Struct.class) {
            return SQLTypeUtils.coerceToStruct(val, sourceType, typeMap, connection);
        }
        if (targetType == Record.class) {
            return SQLTypeUtils.coerceToRecord(format, val, sourceType, typeMap, zone, connection);
        }
        if (targetType == UUID.class) {
            return SQLTypeUtils.coerceToUUID(val, connection);
        }
        if (SQLXML.class.isAssignableFrom(targetType)) {
            return SQLTypeUtils.coerceToXML(val, connection);
        }
        if (SQLData.class.isAssignableFrom(targetType)) {
            return SQLTypeUtils.coerceToCustomType(val, sourceType, targetType, typeMap, connection);
        }
        if (val instanceof String && sourceType.isParameterFormatSupported(ResultField.Format.Text)) {
            try {
                return sourceType.getCodec(ResultField.Format.Text).getDecoder().decode(sourceType, sourceType.getLength(), null, val, connection);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val);
    }

    public static byte coerceToByte(Object val) throws SQLException {
        if (val == null) {
            return 0;
        }
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            try {
                return new BigDecimal(val.toString()).setScale(0, RoundingMode.HALF_EVEN).byteValueExact();
            }
            catch (ArithmeticException e) {
                throw new SQLException("Coercion error", e);
            }
        }
        if (val instanceof String) {
            return Byte.parseByte(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? (byte)1 : 0;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Byte.TYPE, val);
    }

    public static short coerceToShort(Object val) throws SQLException {
        if (val == null) {
            return 0;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        if (val instanceof Byte) {
            return ((Byte)val).byteValue();
        }
        if (val instanceof Number) {
            try {
                return new BigDecimal(val.toString()).setScale(0, RoundingMode.HALF_EVEN).shortValueExact();
            }
            catch (ArithmeticException e) {
                throw new SQLException("Coercion error", e);
            }
        }
        if (val instanceof String) {
            return Short.parseShort(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? (short)1 : 0;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Short.TYPE, val);
    }

    public static int coerceToInt(Object val) throws SQLException {
        if (val == null) {
            return 0;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Short) {
            return ((Short)val).shortValue();
        }
        if (val instanceof Byte) {
            return ((Byte)val).byteValue();
        }
        if (val instanceof Number) {
            try {
                return new BigDecimal(val.toString()).setScale(0, RoundingMode.HALF_EVEN).intValueExact();
            }
            catch (ArithmeticException e) {
                throw new SQLException("Coercion error", e);
            }
        }
        if (val instanceof String) {
            return Integer.parseInt(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1 : 0;
        }
        if (val instanceof PGBlob) {
            return ((PGBlob)val).lo.oid;
        }
        if (val instanceof PGClob) {
            return ((PGClob)val).lo.oid;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Integer.TYPE, val);
    }

    public static long coerceToLong(Object val) throws SQLException {
        if (val == null) {
            return 0L;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        if (val instanceof Short) {
            return ((Short)val).shortValue();
        }
        if (val instanceof Byte) {
            return ((Byte)val).byteValue();
        }
        if (val instanceof Number) {
            try {
                return new BigDecimal(val.toString()).setScale(0, RoundingMode.HALF_EVEN).longValueExact();
            }
            catch (ArithmeticException e) {
                throw new SQLException("Coercion error", e);
            }
        }
        if (val instanceof String) {
            return Long.parseLong(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1L : 0L;
        }
        if (val instanceof PGBlob) {
            return ((PGBlob)val).lo.oid;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Long.TYPE, val);
    }

    public static float coerceToFloat(Object val) throws SQLException {
        if (val == null) {
            return 0.0f;
        }
        if (val instanceof Float) {
            return ((Float)val).floatValue();
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        if (val instanceof String) {
            return Float.parseFloat(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0f : 0.0f;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Float.TYPE, val);
    }

    public static double coerceToDouble(Object val) throws SQLException {
        if (val == null) {
            return 0.0;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof String) {
            return Double.parseDouble(((String)val).trim());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Double.TYPE, val);
    }

    public static BigDecimal coerceToBigDecimal(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        if (val instanceof Boolean) {
            return new BigDecimal((Boolean)val != false ? "1.0" : "0.0");
        }
        if (val instanceof String) {
            return new BigDecimal(((String)val).trim());
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), BigDecimal.class, val);
    }

    public static boolean coerceToBoolean(Object val) throws SQLException {
        if (val == null) {
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue() != 0;
        }
        if (val instanceof String) {
            String str = ((String)val).trim().toLowerCase();
            try {
                return Long.parseLong(str) != 0L;
            }
            catch (Exception exception) {
                try {
                    return Double.parseDouble(str) != 0.0;
                }
                catch (Exception exception2) {
                    switch (str) {
                        case "on": 
                        case "true": 
                        case "t": {
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Boolean.TYPE, val);
    }

    public static String coerceToString(Object val, Type type, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Number) {
            return ((Number)val).toString();
        }
        if (val instanceof Character) {
            return new String(new char[]{((Character)val).charValue()});
        }
        if (val instanceof Boolean) {
            return val.toString();
        }
        if (val instanceof URL) {
            return val.toString();
        }
        if (val instanceof Time) {
            return val.toString();
        }
        if (val instanceof Date) {
            return val.toString();
        }
        if (val instanceof Timestamp) {
            return val.toString();
        }
        if (val instanceof Interval) {
            return val.toString();
        }
        if (val instanceof Instant) {
            return ((Instant)val).disambiguate(TimeZone.getDefault()).print(context);
        }
        if (val instanceof PGSQLXML) {
            return ((PGSQLXML)val).getString();
        }
        if (type.isResultFormatSupported(ResultField.Format.Text)) {
            return SQLTypeUtils.coerceToStringFromType(val, type, context);
        }
        if (val instanceof byte[]) {
            return new String((byte[])val, context.getCharset());
        }
        return val.toString();
    }

    public static Date coerceToDate(Object val, TimeZone zone, Context context) throws SQLException {
        Instant inst;
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof Instant && (inst = (Instant)val).getType() != Instant.Type.Time) {
            return inst.switchTo(zone).toDate();
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Date.class, val);
    }

    public static Time coerceToTime(Object val, TimeZone zone, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Time) {
            return (Time)val;
        }
        if (val instanceof Instant) {
            Instant inst = (Instant)val;
            if (inst.getType() != Instant.Type.Date && inst.getType() != Instant.Type.Infinity) {
                return ((Instant)val).switchTo(zone).toTime();
            }
        } else if (val instanceof String) {
            return Time.valueOf(((String)val).trim());
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Time.class, val);
    }

    public static Timestamp coerceToTimestamp(Object val, TimeZone zone, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Timestamp) {
            return (Timestamp)val;
        }
        if (val instanceof Instant) {
            return ((Instant)val).switchTo(zone).toTimestamp();
        }
        if (val instanceof String) {
            return Timestamp.valueOf(((String)val).trim());
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Timestamp.class, val);
    }

    public static Interval coerceToInterval(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Interval) {
            return (Interval)val;
        }
        if (val instanceof String) {
            return new Interval((String)val);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Interval.class, val);
    }

    public static Instant coerceToInstant(Object val, Type sourceType, TimeZone zone, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Instant) {
            return ((Instant)val).disambiguate(zone);
        }
        if (val instanceof Date) {
            return Instants.fromDate((Date)val, zone);
        }
        if (val instanceof Time) {
            return Instants.fromTime((Time)val, zone);
        }
        if (val instanceof Timestamp) {
            return Instants.fromTimestamp((Timestamp)val, zone);
        }
        if (val instanceof String) {
            String str = (String)val;
            switch (sourceType.getPrimitiveType()) {
                case Date: {
                    HashMap<String, Object> pieces = new HashMap<String, Object>();
                    int offset = context.getDateFormatter().getParser().parse(str, 0, pieces);
                    if (offset < 0) {
                        throw SQLTypeUtils.createCoercionParseException(str, ~offset, Date.class);
                    }
                    return Instants.dateFromPieces(pieces, zone);
                }
                case Time: 
                case TimeTZ: {
                    HashMap<String, Object> pieces = new HashMap<String, Object>();
                    int offset = context.getTimeFormatter().getParser().parse(val.toString(), 0, pieces);
                    if (offset < 0) {
                        throw SQLTypeUtils.createCoercionParseException(str, ~offset, Time.class);
                    }
                    return Instants.timeFromPieces(pieces, zone);
                }
                case Timestamp: 
                case TimestampTZ: {
                    HashMap<String, Object> pieces = new HashMap<String, Object>();
                    int offset = context.getTimestampFormatter().getParser().parse(val.toString(), 0, pieces);
                    if (offset < 0) {
                        throw SQLTypeUtils.createCoercionParseException(str, ~offset, Timestamp.class);
                    }
                    return Instants.timestampFromPieces(pieces, zone);
                }
            }
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Instant.class, val);
    }

    public static URL coerceToURL(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof URL) {
            return (URL)val;
        }
        if (val instanceof String) {
            try {
                return new URL((String)val);
            }
            catch (MalformedURLException e) {
                throw SQLTypeUtils.createCoercionException(val.getClass(), URL.class, val, e);
            }
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), URL.class, val);
    }

    public static Blob coerceToBlob(Object val, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Blob) {
            return (Blob)val;
        }
        if (val instanceof Integer) {
            return new PGBlob(connection, (Integer)val);
        }
        if (val instanceof Long) {
            return new PGBlob(connection, (int)((Long)val).longValue());
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Blob.class, val);
    }

    public static RowId coerceToRowId(Object val, Type sourceType) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof RowId) {
            return (RowId)val;
        }
        if (val instanceof Tid) {
            return new PGRowId((Tid)val);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), RowId.class, val);
    }

    public static Tid coerceToTid(Object val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Tid) {
            return (Tid)val;
        }
        if (val instanceof PGRowId) {
            PGRowId rowId = (PGRowId)val;
            return rowId.tid;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Tid.class, val);
    }

    public static InputStream coerceToByteStream(Object val, Type sourceType, Context context) throws SQLException {
        return SQLTypeUtils.coerceToByteStream(sourceType.getPreferredFormat(), val, sourceType, context);
    }

    public static InputStream coerceToByteStream(ResultField.Format format, Object val, Type sourceType, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof InputStream) {
            InputStream is = (InputStream)val;
            try {
                is.reset();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            return is;
        }
        if (val instanceof byte[]) {
            return new ByteArrayInputStream((byte[])val);
        }
        if (val instanceof String) {
            return new ByteArrayInputStream(((String)val).getBytes(context.getCharset()));
        }
        if (val instanceof PGSQLXML) {
            byte[] data = ((PGSQLXML)val).getData();
            return data != null ? new ByteArrayInputStream(data) : null;
        }
        if (sourceType.getJavaType(format, Collections.emptyMap()).isInstance(val)) {
            final ByteBuf buffer = Unpooled.buffer();
            try {
                sourceType.getBinaryCodec().getEncoder().encode(sourceType, buffer, val, context);
            }
            catch (IOException e) {
                throw SQLTypeUtils.createCoercionException(val.getClass(), byte[].class, val);
            }
            buffer.skipBytes(4);
            return new ByteBufInputStream(buffer){

                public void close() throws IOException {
                    super.close();
                    buffer.release();
                }
            };
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), byte[].class, val);
    }

    public static byte[] coerceToBytes(Object val, Type sourceType, Context context) throws SQLException {
        return SQLTypeUtils.coerceToBytes(sourceType.getPreferredFormat(), val, sourceType, context);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] coerceToBytes(ResultField.Format format, Object val, Type sourceType, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof InputStream) {
            try (InputStream is = (InputStream)val;){
                byte[] byArray = ByteStreams.toByteArray(is);
                return byArray;
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        if (val instanceof String) {
            if (!sourceType.isParameterFormatSupported(ResultField.Format.Text)) return ((String)val).getBytes(context.getCharset());
            if (sourceType.getTextCodec().getDecoder().getOutputType() != byte[].class) return ((String)val).getBytes(context.getCharset());
            try {
                return (byte[])sourceType.getTextCodec().getDecoder().decode(sourceType, sourceType.getLength(), null, val, context);
            }
            catch (IOException e) {
                throw SQLTypeUtils.createCoercionException(val.getClass(), byte[].class, val);
            }
        }
        if (val instanceof PGSQLXML) {
            return ((PGSQLXML)val).getData();
        }
        if (!sourceType.getJavaType(format, Collections.emptyMap()).isInstance(val)) throw SQLTypeUtils.createCoercionException(val.getClass(), byte[].class, val);
        ByteBuf buffer = Unpooled.buffer();
        try {
            sourceType.getBinaryCodec().getEncoder().encode(sourceType, buffer, val, context);
        }
        catch (IOException e) {
            throw SQLTypeUtils.createCoercionException(val.getClass(), byte[].class, val);
        }
        buffer.skipBytes(4);
        byte[] array = new byte[buffer.readableBytes()];
        buffer.readBytes(array);
        return array;
    }

    public static Clob coerceToClob(Object val, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Clob) {
            return (Clob)val;
        }
        if (val instanceof Integer) {
            return new PGClob(connection, (Integer)val);
        }
        if (val instanceof Long) {
            return new PGClob(connection, (int)((Long)val).longValue());
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Clob.class, val);
    }

    public static Object coerceToArray(Object val, Type type, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        return SQLTypeUtils.coerceToArray(type.getPreferredFormat(), val, type, targetType, typeMap, connection);
    }

    public static Object coerceToArray(ResultField.Format format, Object val, Type type, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof PGArray) {
            return SQLTypeUtils.coerceToArray(format, ((PGArray)val).getValue(), type, targetType, typeMap, connection);
        }
        if (val.getClass().isArray()) {
            return SQLTypeUtils.coerceToArray(format, val, 0, Array.getLength(val), type, targetType, typeMap, connection);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val);
    }

    public static Object coerceToArray(Object val, int index, int count, Type type, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        return SQLTypeUtils.coerceToArray(type.getPreferredFormat(), val, index, count, type, targetType, typeMap, connection);
    }

    public static Object coerceToArray(ResultField.Format format, Object val, int index, int count, Type type, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof PGArray) {
            return SQLTypeUtils.coerceToArray(format, ((PGArray)val).getValue(), index, count, type, targetType, typeMap, connection);
        }
        if (val.getClass() == type.getJavaType(format, typeMap) && targetType.isArray()) {
            Object array = Array.newInstance(targetType.getComponentType(), count);
            int end = index + count;
            for (int c = index; c < end; ++c) {
                Array.set(array, c - index, SQLTypeUtils.coerce(format, Array.get(val, c), type, targetType.getComponentType(), typeMap, connection));
            }
            return array;
        }
        if (val.getClass().isArray() && targetType.isArray()) {
            Object dst;
            int targetDims = ArrayUtils.getDimensions(targetType);
            if (targetDims == 1) {
                targetDims = ArrayUtils.getDimensions(val);
                targetType = Array.newInstance(targetType.getComponentType(), new int[targetDims]).getClass();
            }
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).getElementType();
            }
            Class<?> elementClass = targetType.getComponentType();
            if (count == 0) {
                dst = Array.newInstance(targetType.getComponentType(), count);
            } else if (val.getClass().getComponentType() == targetType.getComponentType()) {
                dst = index == 0 && count == Array.getLength(val) ? val : Arrays.copyOfRange((Object[])val, index, index + count);
            } else if (Array.get(val, 0) != null && elementClass.isAssignableFrom(Array.get(val, 0).getClass())) {
                dst = Array.newInstance(targetType.getComponentType(), count);
                for (int i = 0; i < count; ++i) {
                    Array.set(dst, i, Array.get(val, i + index));
                }
            } else {
                dst = Array.newInstance(targetType.getComponentType(), count);
                int end = index + count;
                for (int c = index; c < end; ++c) {
                    Array.set(dst, c, SQLTypeUtils.coerce(format, Array.get(val, c), type, elementClass, typeMap, connection));
                }
            }
            return dst;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val);
    }

    public static Struct coerceToStruct(Object val, Type sourceType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Struct) {
            return (Struct)val;
        }
        if (val instanceof Record) {
            return new PGStruct(connection, ((Record)val).getTypeName(), ((Record)val).getAttributeTypes(), ((Record)val).getAttributeValues());
        }
        if (SQLData.class.isInstance(val) && sourceType instanceof CompositeType) {
            CompositeType compType = (CompositeType)sourceType;
            PGSQLOutputImpl out = new PGSQLOutputImpl(connection, compType);
            ((SQLData)val).writeSQL(out);
            return new PGStruct(connection, compType.getName(), compType.getAttributesTypes(), out.getAttributeValues());
        }
        if (val instanceof Object[] && sourceType instanceof CompositeType) {
            CompositeType compType = (CompositeType)sourceType;
            return new PGStruct(connection, compType.getName(), compType.getAttributesTypes(), (Object[])val);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Struct.class, val);
    }

    public static Record coerceToRecord(ResultField.Format format, Object val, Type sourceType, Map<String, Class<?>> typeMap, TimeZone zone, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof Record) {
            return (Record)val;
        }
        if (sourceType instanceof CompositeType) {
            Object[] attributeVals;
            CompositeType compType = (CompositeType)sourceType;
            if (val instanceof Struct) {
                Struct struct = (Struct)val;
                attributeVals = struct.getAttributes();
            } else if (SQLData.class.isInstance(val)) {
                PGSQLOutputImpl out = new PGSQLOutputImpl(connection, compType);
                ((SQLData)val).writeSQL(out);
                attributeVals = out.getAttributeValues();
            } else {
                throw SQLTypeUtils.createCoercionException(val.getClass(), Record.class, val);
            }
            if (compType.getAttributes().size() != attributeVals.length) {
                throw SQLTypeUtils.createCoercionException(val.getClass(), Record.class, val);
            }
            for (int c = 0; c < attributeVals.length; ++c) {
                Type attrType = compType.getAttribute(c + 1).getType();
                Class<?> attrTargetType = SQLTypeUtils.mapSetType(format, attrType);
                attributeVals[c] = SQLTypeUtils.coerce(format, attributeVals[c], attrType, attrTargetType, typeMap, zone, connection);
            }
            return new Record(compType.getName(), compType.getAttributesTypes(), attributeVals);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), Struct.class, val);
    }

    public static Object coerceToCustomType(Object val, Type sourceType, Class<?> targetType, Map<String, Class<?>> typeMap, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (sourceType instanceof CompositeType) {
            Object dst;
            Object[] attributeVals;
            CompositeType compType = (CompositeType)sourceType;
            if (val instanceof Struct) {
                Struct struct = (Struct)val;
                attributeVals = struct.getAttributes();
            } else if (val instanceof Record) {
                Record record = (Record)val;
                attributeVals = record.getAttributeValues();
            } else {
                throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val);
            }
            try {
                dst = targetType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val, e);
            }
            PGSQLInputImpl in = new PGSQLInputImpl(connection, compType, typeMap, attributeVals);
            ((SQLData)dst).readSQL(in, compType.getName());
            return dst;
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), targetType, val);
    }

    public static UUID coerceToUUID(Object val, Context context) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return UUID.fromString((String)val);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), UUID.class, val);
    }

    public static SQLXML coerceToXML(Object val, PGConnectionImpl connection) throws SQLException {
        if (val == null) {
            return null;
        }
        if (val instanceof SQLXML) {
            return (SQLXML)val;
        }
        if (val instanceof String) {
            return new PGSQLXML(connection, ((String)val).getBytes(connection.getCharset()));
        }
        if (val instanceof byte[]) {
            return new PGSQLXML(connection, (byte[])val);
        }
        throw SQLTypeUtils.createCoercionException(val.getClass(), SQLXML.class, val);
    }

    public static SQLException createCoercionException(Class<?> srcType, Class<?> dstType) {
        return new SQLException("Coercion from '" + srcType.getName() + "' to '" + dstType.getName() + "' is not supported");
    }

    public static SQLException createCoercionException(Class<?> srcType, Class<?> dstType, Object val) {
        return new SQLException("Coercion from '" + srcType.getName() + "' to '" + dstType.getName() + "' is not supported (" + val + ")");
    }

    public static SQLException createCoercionException(Class<?> srcType, Class<?> dstType, Object val, Exception cause) {
        return new SQLException("Coercion from '" + srcType.getName() + "' to '" + dstType.getName() + "' failed (" + val + ")", cause);
    }

    public static SQLException createCoercionParseException(String val, int parseErrorPos, Class<?> dstType) {
        String errorText = "";
        int parseErrorEndPos = Math.min(parseErrorPos + 15, val.length());
        if (parseErrorEndPos < val.length()) {
            parseErrorEndPos -= 3;
            errorText = "...";
        }
        errorText = val.substring(parseErrorPos, parseErrorEndPos) + errorText;
        return new SQLException("Coercion from 'String' to '" + dstType.getName() + "' failed. Parser error near '" + errorText + "'");
    }

    public static String coerceToStringFromType(Object val, Type type, Context context) throws SQLException {
        try {
            StringBuilder buffer = new StringBuilder();
            type.getCodec(ResultField.Format.Text).getEncoder().encode(type, buffer, val, context);
            return buffer.toString();
        }
        catch (IOException e) {
            throw SQLTypeUtils.createCoercionException(val.getClass(), String.class, val);
        }
    }
}

