/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.api.jdbc.PGNotificationListener;
import com.impossibl.postgres.jdbc.CachedStatement;
import com.impossibl.postgres.jdbc.CachedStatementKey;
import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.Housekeeper;
import com.impossibl.postgres.jdbc.LargeObject;
import com.impossibl.postgres.jdbc.PGArray;
import com.impossibl.postgres.jdbc.PGBlob;
import com.impossibl.postgres.jdbc.PGCallableStatement;
import com.impossibl.postgres.jdbc.PGClob;
import com.impossibl.postgres.jdbc.PGDatabaseMetaData;
import com.impossibl.postgres.jdbc.PGPreparedStatement;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.PGSQLXML;
import com.impossibl.postgres.jdbc.PGSavepoint;
import com.impossibl.postgres.jdbc.PGSimpleStatement;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.PGStruct;
import com.impossibl.postgres.jdbc.SQLText;
import com.impossibl.postgres.jdbc.SQLTextEscapes;
import com.impossibl.postgres.jdbc.SQLTextTree;
import com.impossibl.postgres.jdbc.SQLTextUtils;
import com.impossibl.postgres.protocol.Command;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.Protocol;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.types.ArrayType;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.BlockingReadTimeoutException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.net.SocketAddress;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class PGConnectionImpl
extends BasicContext
implements PGConnection {
    boolean strict = this.getSetting("strictMode", false);
    long statementId = 0L;
    long portalId = 0L;
    int savepointId;
    private int holdability;
    boolean autoCommit = true;
    int networkTimeout = this.getSetting("networkTimeout", 0);
    SQLWarning warningChain;
    List<WeakReference<PGStatement>> activeStatements = new ArrayList<WeakReference<PGStatement>>();
    Map<CachedStatementKey, CachedStatement> preparedStatementCache;
    int defaultFetchSize;
    final Housekeeper.Ref housekeeper;
    final Object cleanupKey;
    static Map<String, SQLText> parsedSqlCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    PGConnectionImpl(SocketAddress address, Properties settings, Housekeeper.Ref housekeeper) throws IOException, NoticeException {
        super(address, settings, Collections.emptyMap());
        int sqlCacheSize;
        final int statementCacheSize = this.getSetting("preparedStatementCacheSize", 50);
        if (statementCacheSize > 0) {
            this.preparedStatementCache = Collections.synchronizedMap(new LinkedHashMap<CachedStatementKey, CachedStatement>(statementCacheSize + 1, 1.1f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<CachedStatementKey, CachedStatement> eldest) {
                    if (this.size() > statementCacheSize) {
                        try {
                            PGStatement.dispose(PGConnectionImpl.this, ServerObjectType.Statement, eldest.getValue().name);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        if ((sqlCacheSize = this.getSetting("parsedSqlCacheSize", 250).intValue()) > 0) {
            Class<PGConnectionImpl> clazz = PGConnectionImpl.class;
            // MONITORENTER : com.impossibl.postgres.jdbc.PGConnectionImpl.class
            if (parsedSqlCache == null) {
                parsedSqlCache = Collections.synchronizedMap(new LinkedHashMap<String, SQLText>(sqlCacheSize + 1, 1.1f, true){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, SQLText> eldest) {
                        return this.size() > sqlCacheSize;
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        this.defaultFetchSize = this.getSetting("defaultFetchSize", 0);
        this.housekeeper = housekeeper;
        if (this.housekeeper != null) {
            this.cleanupKey = this.housekeeper.add(this, new Cleanup(this.protocol, housekeeper, this.activeStatements, settings.getProperty("databaseUrl")));
            return;
        }
        this.cleanupKey = null;
    }

    @Override
    public void init() throws IOException, NoticeException {
        super.init();
        this.applySettings(this.settings);
    }

    void applySettings(Properties settings) throws IOException {
        if (Boolean.parseBoolean(settings.getProperty("readOnly", "false"))) {
            try {
                this.setReadOnly(true);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    public void addWarning(SQLWarning warning) {
        this.warningChain = ErrorUtils.chainWarnings(this.warningChain, warning);
    }

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("connection closed", "08006");
        }
    }

    void checkManualCommit() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("must not be in auto-commit mode");
        }
    }

    void checkAutoCommit() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("must be in auto-commit mode");
        }
    }

    void checkTransaction() throws SQLException {
        if (!this.autoCommit && this.protocol.getTransactionStatus() == TransactionStatus.Idle) {
            this.execute(SQLTextUtils.getBeginText(), false);
        }
    }

    String getNextStatementName() {
        return Long.toHexString(++this.statementId);
    }

    String getNextPortalName() {
        return Long.toHexString(++this.portalId);
    }

    void handleStatementClosure(PGStatement statement) {
        Iterator<WeakReference<PGStatement>> statementRefIter = this.activeStatements.iterator();
        while (statementRefIter.hasNext()) {
            WeakReference<PGStatement> statementRef = statementRefIter.next();
            PGStatement s = (PGStatement)statementRef.get();
            if (s == null) {
                statementRefIter.remove();
                continue;
            }
            if (s != statement) continue;
            statementRefIter.remove();
            break;
        }
    }

    static void closeStatements(List<WeakReference<PGStatement>> statements) {
        for (WeakReference<PGStatement> statementRef : statements) {
            PGStatement statement = (PGStatement)statementRef.get();
            if (statement == null) continue;
            try {
                statement.internalClose();
            }
            catch (SQLException sQLException) {}
        }
    }

    void closeStatements() throws SQLException {
        PGConnectionImpl.closeStatements(this.activeStatements);
        this.activeStatements.clear();
    }

    SQLText parseSQL(String sqlText) throws SQLException {
        try {
            boolean standardConformingStrings = this.getSetting("standard_conforming_strings", false);
            if (parsedSqlCache == null) {
                return new SQLText(sqlText, standardConformingStrings);
            }
            SQLText parsedSql = parsedSqlCache.get(sqlText);
            if (parsedSql == null) {
                parsedSql = new SQLText(sqlText, standardConformingStrings);
                parsedSqlCache.put(sqlText, parsedSql);
            }
            return parsedSql.copy();
        }
        catch (ParseException e) {
            throw new SQLException("Error parsing SQL at position " + e.getErrorOffset() + " (" + sqlText + "): " + e.getMessage());
        }
    }

    SQLWarning execute(Command cmd, boolean checkTxn) throws SQLException {
        if (checkTxn) {
            this.checkTransaction();
        }
        cmd.setNetworkTimeout(this.networkTimeout);
        try {
            this.protocol.execute(cmd);
            if (cmd.getError() != null) {
                throw ErrorUtils.makeSQLException(cmd.getError());
            }
            return ErrorUtils.makeSQLWarningChain(cmd.getWarnings());
        }
        catch (BlockingReadTimeoutException e) {
            this.close();
            throw new SQLTimeoutException(e);
        }
        catch (InterruptedIOException e) {
            this.close();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            if (!this.protocol.isConnected()) {
                this.close();
            }
            throw new SQLException(e);
        }
    }

    void execute(String sql, boolean checkTxn) throws SQLException {
        if (checkTxn) {
            this.checkTransaction();
        }
        try {
            this.query(sql);
        }
        catch (BlockingReadTimeoutException e) {
            this.internalClose();
            throw new SQLTimeoutException(e);
        }
        catch (InterruptedIOException e) {
            this.internalClose();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw new SQLException(e);
        }
        catch (NoticeException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw ErrorUtils.makeSQLException(e.getNotice());
        }
    }

    String executeForString(String sql, boolean checkTxn) throws SQLException {
        if (checkTxn) {
            this.checkTransaction();
        }
        try {
            return this.queryFirstResultString(sql);
        }
        catch (BlockingReadTimeoutException e) {
            this.internalClose();
            throw new SQLTimeoutException(e);
        }
        catch (InterruptedIOException e) {
            this.internalClose();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw new SQLException(e);
        }
        catch (NoticeException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw ErrorUtils.makeSQLException(e.getNotice());
        }
    }

    QueryCommand.ResultBatch executeForFirstResultBatch(String sql, boolean checkTxn, Object ... params) throws SQLException {
        if (checkTxn) {
            this.checkTransaction();
        }
        try {
            return this.queryBatch(sql, params);
        }
        catch (BlockingReadTimeoutException e) {
            this.internalClose();
            throw new SQLTimeoutException(e);
        }
        catch (InterruptedIOException e) {
            this.internalClose();
            throw Exceptions.CLOSED_CONNECTION;
        }
        catch (IOException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw new SQLException(e);
        }
        catch (NoticeException e) {
            if (!this.protocol.isConnected()) {
                this.internalClose();
            }
            throw ErrorUtils.makeSQLException(e.getNotice());
        }
    }

    DataRow executeForFirstResult(String sql, boolean checkTxn, Object ... params) throws SQLException {
        QueryCommand.ResultBatch resultBatch = this.executeForFirstResultBatch(sql, checkTxn, params);
        List<DataRow> res = resultBatch.getResults();
        if (res == null || res.isEmpty()) {
            return null;
        }
        DataRow firstResult = res.remove(0);
        resultBatch.release();
        return firstResult;
    }

    <T> T executeForFirstResultValue(String sql, boolean checkTxn, Class<T> returnType, Object ... params) throws SQLException {
        DataRow result = this.executeForFirstResult(sql, checkTxn, params);
        if (result == null) {
            return null;
        }
        try {
            T t = returnType.cast(result.getColumn(0));
            return t;
        }
        catch (IOException e) {
            throw new SQLException("Error decoding column", e);
        }
        finally {
            result.release();
        }
    }

    long executeForRowsAffected(String sql, boolean checkTxn, Object ... params) throws SQLException {
        QueryCommand.ResultBatch resultBatch = this.executeForFirstResultBatch(sql, checkTxn, params);
        resultBatch.release();
        return resultBatch.getRowsAffected();
    }

    @Override
    public void setStrictMode(boolean v) {
        this.strict = v;
    }

    @Override
    public boolean isStrictMode() {
        return this.strict;
    }

    @Override
    public void setDefaultFetchSize(int v) {
        this.defaultFetchSize = v;
    }

    @Override
    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    void internalClose() throws SQLException {
        this.closeStatements();
        this.shutdown();
        this.notificationListeners.clear();
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
            this.housekeeper.release();
        }
    }

    @Override
    public boolean isServerMinimumVersion(int major, int minor) {
        return this.getServerVersion().isMinimum(major, minor);
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        if (timeout < 0) {
            throw new SQLException("Timeout is less than 0");
        }
        boolean result = true;
        int origNetworkTimeout = this.networkTimeout;
        try {
            this.networkTimeout = timeout * 1000;
            result = this.executeForString("SELECT '1'::char", false).equals("1");
        }
        catch (SQLException se) {
            result = false;
        }
        this.networkTimeout = origNetworkTimeout;
        return result;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return this.targetTypeMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        this.checkClosed();
        this.targetTypeMap = Collections.unmodifiableMap(typeMap);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.holdability;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("illegal argument");
        }
        this.holdability = holdability;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new PGDatabaseMetaData(this);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (!this.autoCommit && this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute(SQLTextUtils.getCommitText(), false);
        }
        this.autoCommit = autoCommit;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        String readability = this.executeForString(SQLTextUtils.getGetSessionReadabilityText(), false);
        return SQLTextUtils.isTrue(readability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        if (this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
            throw new SQLException("cannot set read only during a transaction");
        }
        this.execute(SQLTextUtils.getSetSessionReadabilityText(readOnly), false);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        String isolLevel = this.executeForString(SQLTextUtils.getGetSessionIsolationLevelText(), false);
        return SQLTextUtils.getIsolationLevel(isolLevel);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        if (level != 0 && level != 1 && level != 2 && level != 4 && level != 8) {
            throw new SQLException("illegal argument");
        }
        this.execute(SQLTextUtils.getSetSessionIsolationLevelText(level), false);
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        if (this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute(SQLTextUtils.getCommitText(), false);
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        if (this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
            this.execute(SQLTextUtils.getRollbackText(), false);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = new PGSavepoint(++this.savepointId);
        this.execute(SQLTextUtils.getSetSavepointText(savepoint), true);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = new PGSavepoint(name);
        this.execute(SQLTextUtils.getSetSavepointText(savepoint), true);
        return savepoint;
    }

    @Override
    public void rollback(Savepoint savepointParam) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = (PGSavepoint)savepointParam;
        if (!savepoint.isValid()) {
            throw new SQLException("invalid savepoint");
        }
        try {
            if (this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
                this.execute(SQLTextUtils.getRollbackToText(savepoint), false);
            }
        }
        finally {
            savepoint.setReleased(true);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepointParam) throws SQLException {
        this.checkClosed();
        this.checkManualCommit();
        PGSavepoint savepoint = (PGSavepoint)savepointParam;
        if (!savepoint.isValid()) {
            throw new SQLException("invalid savepoint");
        }
        try {
            if (!savepoint.getReleased() && this.protocol.getTransactionStatus() != TransactionStatus.Idle) {
                this.execute(SQLTextUtils.getReleaseSavepointText(savepoint), false);
            }
        }
        finally {
            savepoint.invalidate();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        SQLTextEscapes.processEscapes(sqlText, this);
        return sqlText.toString();
    }

    @Override
    public PGStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 2);
    }

    @Override
    public PGStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PGStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        PGSimpleStatement statement = new PGSimpleStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.activeStatements.add(new WeakReference<PGSimpleStatement>(statement));
        return statement;
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 2);
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public PGPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        return this.prepareStatement(sqlText, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PGPreparedStatement prepareStatement(SQLText sqlText, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SQLTextEscapes.processEscapes(sqlText, this);
        String statementName = this.getNextStatementName();
        String cursorName = null;
        if (!(resultSetType == 1003 && resultSetConcurrency != 1008 || SQLTextUtils.prependCursorDeclaration(sqlText, cursorName = "cursor" + statementName, resultSetType, resultSetHoldability, this.autoCommit))) {
            cursorName = null;
        }
        final int[] parameterCount = new int[1];
        sqlText.process(new SQLTextTree.Processor(){

            @Override
            public SQLTextTree.Node process(SQLTextTree.Node node) throws SQLException {
                if (node instanceof SQLTextTree.ParameterPiece) {
                    parameterCount[0] = parameterCount[0] + 1;
                }
                return node;
            }
        }, true);
        if (parameterCount[0] > 65535) {
            throw new PGSQLSimpleException("Too many parameters specified: Max of 65535 allowed");
        }
        PGPreparedStatement statement = new PGPreparedStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, statementName, sqlText.toString(), parameterCount[0], cursorName);
        this.activeStatements.add(new WeakReference<PGPreparedStatement>(statement));
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        if (autoGeneratedKeys != 1) {
            return this.prepareStatement(sql);
        }
        if (!SQLTextUtils.appendReturningClause(sqlText)) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        PGPreparedStatement statement = this.prepareStatement(sqlText, 1003, 1007, 2);
        statement.setWantsGeneratedKeys(true);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        if (!SQLTextUtils.appendReturningClause(sqlText, Arrays.asList(columnNames))) {
            throw Exceptions.INVALID_COMMAND_FOR_GENERATED_KEYS;
        }
        PGPreparedStatement statement = this.prepareStatement(sqlText, 1003, 1007, 2);
        statement.setWantsGeneratedKeys(true);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        SQLText sqlText = this.parseSQL(sql);
        return this.prepareCall(sqlText, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public PGCallableStatement prepareCall(SQLText sqlText, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        final int[] parameterCount = new int[1];
        SQLTextTree.Processor counter = new SQLTextTree.Processor(){

            @Override
            public SQLTextTree.Node process(SQLTextTree.Node node) throws SQLException {
                if (node instanceof SQLTextTree.ParameterPiece) {
                    parameterCount[0] = parameterCount[0] + 1;
                }
                return node;
            }
        };
        sqlText.process(counter, true);
        int preParameterCount = parameterCount[0];
        SQLTextEscapes.processEscapes(sqlText, this);
        parameterCount[0] = 0;
        sqlText.process(counter, true);
        int finalParameterCount = parameterCount[0];
        String statementName = this.getNextStatementName();
        String cursorName = null;
        if (!(resultSetType == 1003 && resultSetConcurrency != 1008 || SQLTextUtils.prependCursorDeclaration(sqlText, cursorName = "cursor" + statementName, resultSetType, resultSetHoldability, this.autoCommit))) {
            cursorName = null;
        }
        boolean hasAssign = preParameterCount == finalParameterCount + 1;
        PGCallableStatement statement = new PGCallableStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability, statementName, sqlText.toString(), parameterCount[0], cursorName, hasAssign);
        this.activeStatements.add(new WeakReference<PGCallableStatement>(statement));
        return statement;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        int loOid = LargeObject.creat(this, 0);
        return new PGBlob(this, loOid);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        int loOid = LargeObject.creat(this, 0);
        return new PGClob(this, loOid);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new PGSQLXML(this);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        Type type = this.getRegistry().loadType(typeName + "[]");
        if (type == null) {
            throw new SQLException("Array type not found");
        }
        return new PGArray(this, (ArrayType)type, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        Type type = this.getRegistry().loadType(typeName);
        if (!(type instanceof CompositeType)) {
            throw new SQLException("Invalid type for struct");
        }
        CompositeType compositeType = (CompositeType)type;
        return new PGStruct(this, type.getName(), compositeType.getAttributesTypes(), attributes);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.protocol.isConnected();
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.internalClose();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.getProtocol().abort(executor);
        this.shutdown();
        if (this.housekeeper != null) {
            this.housekeeper.remove(this.cleanupKey);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.warningChain = null;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return this.networkTimeout;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int networkTimeout) throws SQLException {
        this.checkClosed();
        if (networkTimeout < 0) {
            throw new SQLException("invalid network timeout");
        }
        this.networkTimeout = networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!iface.isAssignableFrom(this.getClass())) {
            throw Exceptions.UNWRAP_ERROR;
        }
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void addNotificationListener(String name, String channelNameFilter, PGNotificationListener listener) {
        super.addNotificationListener(name, channelNameFilter, listener);
    }

    @Override
    public void addNotificationListener(String channelNameFilter, PGNotificationListener listener) {
        super.addNotificationListener(null, channelNameFilter, listener);
    }

    @Override
    public void addNotificationListener(PGNotificationListener listener) {
        super.addNotificationListener(null, null, listener);
    }

    @Override
    public void removeNotificationListener(PGNotificationListener listener) {
        super.removeNotificationListener(listener);
    }

    boolean isCacheEnabled() {
        return this.preparedStatementCache != null;
    }

    CachedStatement getCachedStatement(CachedStatementKey key, Callable<CachedStatement> loader) throws Exception {
        if (this.preparedStatementCache == null) {
            return loader.call();
        }
        CachedStatement cached = this.preparedStatementCache.get(key);
        if (cached == null) {
            cached = loader.call();
            this.preparedStatementCache.put(key, cached);
        }
        return cached;
    }

    static class Cleanup
    implements Housekeeper.CleanupRunnable {
        Protocol protocol;
        List<WeakReference<PGStatement>> statements;
        Housekeeper.Ref housekeeper;
        StackTraceElement[] allocationStackTrace;
        String connectionInfo;

        public Cleanup(Protocol protocol, Housekeeper.Ref housekeeper, List<WeakReference<PGStatement>> statements, String connectionInfo) {
            this.protocol = protocol;
            this.housekeeper = housekeeper;
            this.statements = statements;
            this.allocationStackTrace = new Exception().getStackTrace();
            this.connectionInfo = connectionInfo;
        }

        @Override
        public String getKind() {
            return "connection ( " + this.connectionInfo + " )";
        }

        @Override
        public StackTraceElement[] getAllocationStackTrace() {
            return this.allocationStackTrace;
        }

        @Override
        public void run() {
            this.protocol.shutdown();
            PGConnectionImpl.closeStatements(this.statements);
            this.housekeeper.release();
        }
    }
}

