/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime.instants;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.AmbiguousInstant;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.InstantBase;
import com.impossibl.postgres.system.Context;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class PreciseInstant
extends InstantBase {
    private TimeZone zone;
    private long micros;

    public PreciseInstant(Instant.Type type, long micros, TimeZone zone) {
        super(type);
        this.zone = zone;
        this.micros = micros;
    }

    @Override
    public TimeZone getZone() {
        return this.zone;
    }

    @Override
    public long getZoneOffsetSecs() {
        return TimeUnit.MILLISECONDS.toSeconds(this.getZoneOffsetMillis());
    }

    @Override
    public long getZoneOffsetMicros() {
        return TimeUnit.MILLISECONDS.toMicros(this.getZoneOffsetMillis());
    }

    @Override
    public long getZoneOffsetMillis() {
        return this.zone.getOffset(this.getMillisLocal());
    }

    @Override
    public long getMillisLocal() {
        return TimeUnit.MICROSECONDS.toMillis(this.micros);
    }

    @Override
    public long getMicrosLocal() {
        return this.micros;
    }

    @Override
    public long getMillisUTC() {
        return this.getMillisLocal() - this.getZoneOffsetMillis();
    }

    @Override
    public long getMicrosUTC() {
        return this.micros - this.getZoneOffsetMicros();
    }

    @Override
    public PreciseInstant disambiguate(TimeZone zone) {
        return this;
    }

    @Override
    public PreciseInstant switchTo(TimeZone zone) {
        long zoneOffsetMicros = TimeUnit.MILLISECONDS.toMicros(zone.getOffset(this.getMillisLocal()));
        return new PreciseInstant(this.type, this.getMicrosUTC() + zoneOffsetMicros, zone);
    }

    @Override
    public AmbiguousInstant ambiguate() {
        return new AmbiguousInstant(this.type, this.micros);
    }

    @Override
    public String print(Context context) {
        switch (this.type) {
            case Time: {
                return this.toTime().toString();
            }
            case Date: {
                return this.toDate().toString();
            }
            case Timestamp: {
                return this.toTimestamp().toString();
            }
        }
        return "";
    }

    @Override
    public PreciseInstant add(int field, int amount) {
        long oldMillis = this.getMillisLocal();
        Calendar cal = Calendar.getInstance(TimeZones.UTC);
        cal.setTimeInMillis(oldMillis);
        cal.add(field, amount);
        long diffMillis = cal.getTimeInMillis() - oldMillis;
        long diffMicros = TimeUnit.MILLISECONDS.toMicros(diffMillis);
        return new PreciseInstant(this.type, this.micros + diffMicros, this.zone);
    }

    @Override
    public PreciseInstant subtract(int field, int amount) {
        long oldMillis = this.getMillisLocal();
        Calendar cal = Calendar.getInstance(TimeZones.UTC);
        cal.setTimeInMillis(oldMillis);
        cal.add(field, amount);
        long diffMillis = cal.getTimeInMillis() - oldMillis;
        long diffMicros = TimeUnit.MILLISECONDS.toMicros(diffMillis);
        return new PreciseInstant(this.type, this.micros + diffMicros, this.zone);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.micros ^ this.micros >>> 32);
        result = 31 * result + (this.zone == null ? 0 : this.zone.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AmbiguousInstant) {
            return this.ambiguate().equals(obj);
        }
        if (!(obj instanceof PreciseInstant)) {
            return false;
        }
        PreciseInstant other = (PreciseInstant)obj;
        other = other.switchTo(this.getZone());
        if (this.micros != other.micros) {
            return false;
        }
        return !(this.zone == null ? other.zone != null : this.zone.getRawOffset() != other.zone.getRawOffset());
    }
}

