/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime.instants;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.Instant;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class InfiniteInstant
implements Instant {
    @Override
    public Instant.Type getType() {
        return Instant.Type.Infinity;
    }

    @Override
    public Date toDate() {
        return new Date(this.getMillisLocal());
    }

    @Override
    public Time toTime() {
        throw new IllegalStateException("Infinity cannot be represented as a 'time' value");
    }

    @Override
    public Timestamp toTimestamp() {
        long micros = this.getMicrosLocal();
        long millis = TimeUnit.MICROSECONDS.toMillis(micros);
        long leftoverMicros = micros - TimeUnit.MILLISECONDS.toMicros(millis);
        Timestamp ts = new Timestamp(millis);
        long nanos = (long)ts.getNanos() + TimeUnit.MICROSECONDS.toNanos(leftoverMicros);
        ts.setNanos((int)nanos);
        return ts;
    }

    @Override
    public TimeZone getZone() {
        return TimeZones.UTC;
    }

    @Override
    public long getZoneOffsetSecs() {
        return 0L;
    }

    @Override
    public long getZoneOffsetMicros() {
        return 0L;
    }

    @Override
    public long getZoneOffsetMillis() {
        return 0L;
    }

    @Override
    public Instant switchTo(TimeZone zone) {
        return this;
    }

    @Override
    public Instant disambiguate(TimeZone zone) {
        return this;
    }

    @Override
    public Instant ambiguate() {
        return this;
    }

    @Override
    public Instant add(int field, int value) {
        return this;
    }

    @Override
    public Instant subtract(int field, int value) {
        return this;
    }
}

