/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.datetime.instants;

import com.impossibl.postgres.datetime.TimeZones;
import com.impossibl.postgres.datetime.instants.Instant;
import com.impossibl.postgres.datetime.instants.InstantBase;
import com.impossibl.postgres.datetime.instants.PreciseInstant;
import com.impossibl.postgres.system.Context;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class AmbiguousInstant
extends InstantBase {
    long micros;

    public AmbiguousInstant(Instant.Type type, long micros) {
        super(type);
        this.micros = micros;
    }

    @Override
    public Instant switchTo(TimeZone zone) {
        return new PreciseInstant(this.type, this.micros, zone);
    }

    @Override
    public Instant disambiguate(TimeZone zone) {
        return new PreciseInstant(this.type, this.micros, zone);
    }

    @Override
    public AmbiguousInstant ambiguate() {
        return this;
    }

    @Override
    public long getMillisLocal() {
        return TimeUnit.MICROSECONDS.toMillis(this.micros);
    }

    @Override
    public long getMicrosLocal() {
        return this.micros;
    }

    @Override
    public long getMillisUTC() {
        return this.getMillisLocal();
    }

    @Override
    public long getMicrosUTC() {
        return this.getMicrosLocal();
    }

    @Override
    public String print(Context context) {
        switch (this.type) {
            case Time: {
                return this.toTime().toString();
            }
            case Date: {
                return this.toDate().toString();
            }
            case Timestamp: {
                return this.toTimestamp().toString();
            }
        }
        return "";
    }

    @Override
    public AmbiguousInstant add(int field, int amount) {
        long oldMillis = this.getMillisLocal();
        Calendar cal = Calendar.getInstance(TimeZones.UTC);
        cal.setTimeInMillis(oldMillis);
        cal.add(field, amount);
        long diffMillis = cal.getTimeInMillis() - oldMillis;
        long diffMicros = TimeUnit.MILLISECONDS.toMicros(diffMillis);
        return new AmbiguousInstant(this.type, this.micros + diffMicros);
    }

    @Override
    public AmbiguousInstant subtract(int field, int amount) {
        long oldMillis = this.getMillisLocal();
        Calendar cal = Calendar.getInstance(TimeZones.UTC);
        cal.setTimeInMillis(oldMillis);
        cal.add(field, amount);
        long diffMillis = cal.getTimeInMillis() - oldMillis;
        long diffMicros = TimeUnit.MILLISECONDS.toMicros(diffMillis);
        return new AmbiguousInstant(this.type, this.micros + diffMicros);
    }

    @Override
    public TimeZone getZone() {
        return null;
    }

    @Override
    public long getZoneOffsetSecs() {
        return 0L;
    }

    @Override
    public long getZoneOffsetMicros() {
        return 0L;
    }

    @Override
    public long getZoneOffsetMillis() {
        return 0L;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.micros ^ this.micros >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof PreciseInstant) {
            obj = ((PreciseInstant)obj).ambiguate();
        } else if (!(obj instanceof AmbiguousInstant)) {
            return false;
        }
        AmbiguousInstant other = (AmbiguousInstant)obj;
        return this.micros == other.micros;
    }
}

