/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.api.data;

import java.util.Arrays;

public class Path {
    private boolean closed;
    private double[][] points;

    public Path() {
    }

    public Path(double[][] points, boolean closed) {
        this.setClosed(closed);
        this.setPoints(points);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public double[][] getPoints() {
        return this.points;
    }

    public void setPoints(double[][] points) {
        this.points = points;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.closed ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode((Object[])this.points);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        if (this.closed != other.closed) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.points, (Object[])other.points);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.closed) {
            builder.append('(');
        } else {
            builder.append('[');
        }
        if (this.points != null) {
            for (double[] point : this.points) {
                builder.append('(').append(point[0]).append(',').append(point[1]).append("),");
            }
            builder.setLength(builder.length() - 1);
        }
        if (this.closed) {
            builder.append(')');
        } else {
            builder.append(']');
        }
        return builder.toString();
    }
}

