/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.reflection.Error;
import com.strobel.reflection.Flags;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.lang.model.element.Modifier;

public abstract class FieldInfo
extends MemberInfo {
    public abstract Type getFieldType();

    public abstract Field getRawField();

    public boolean isEnumConstant() {
        return (this.getModifiers() & 0x4000) == 16384;
    }

    @Override
    public final MemberType getMemberType() {
        return MemberType.Field;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.getRawField().getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.getRawField().getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this.getRawField().getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getRawField().isAnnotationPresent(annotationClass);
    }

    public Object getValue(Object instance) {
        Field rawField = this.getRawField();
        if (rawField == null) {
            throw Error.rawFieldBindingFailure(this);
        }
        try {
            return rawField.get(instance);
        }
        catch (IllegalAccessException e) {
            throw Error.targetInvocationException(e);
        }
    }

    public void setValue(Object instance, Object value) {
        Field rawField = this.getRawField();
        if (rawField == null) {
            throw Error.rawFieldBindingFailure(this);
        }
        try {
            rawField.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw Error.targetInvocationException(e);
        }
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        StringBuilder s = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s.append(modifier.toString());
            s.append(' ');
        }
        Type fieldType = this.getFieldType();
        if (fieldType.isGenericParameter()) {
            s.append(fieldType.getName());
        } else {
            s = fieldType.appendBriefDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        return s;
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        Type fieldType;
        StringBuilder s = sb;
        if (this.isStatic()) {
            s.append(Modifier.STATIC.toString());
            s.append(' ');
        }
        if ((fieldType = this.getFieldType()).isGenericParameter()) {
            s.append(fieldType.getName());
        } else {
            s = fieldType.appendBriefDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        return s;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        StringBuilder s = sb;
        for (Modifier modifier : Flags.asModifierSet(this.getModifiers())) {
            s.append(modifier.toString());
            s.append(' ');
        }
        s = this.getFieldType().getErasedType().appendErasedDescription(s);
        s.append(' ');
        s.append(this.getName());
        return s;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        Type fieldType;
        StringBuilder s = sb;
        if (this.isStatic()) {
            s.append(Modifier.STATIC.toString());
            s.append(' ');
        }
        if ((fieldType = this.getFieldType()).isGenericParameter()) {
            s.append(fieldType.getName());
        } else {
            s = fieldType.appendSimpleDescription(s);
        }
        s.append(' ');
        s.append(this.getName());
        return s;
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        return this.getFieldType().appendSignature(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        return this.getFieldType().appendErasedSignature(sb);
    }
}

