/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashFloatObjMap}s.
 *
 * @see HashFloatObjMap
 * @see HashFloatObjMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashFloatObjMapFactory<V>
        extends FloatObjMapFactory<V, HashFloatObjMapFactory<V>>
        , HashContainerFactory<HashFloatObjMapFactory<V>>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap();

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            @Nonnull float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            @Nonnull Map<Float, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            @Nonnull float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newMutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);
    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap();

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(
            @Nonnull float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(
            @Nonnull Map<Float, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(
            @Nonnull float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newUpdatableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);

    


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5, int expectedSize);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            @Nonnull float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values, int expectedSize);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values, int expectedSize);

    

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            @Nonnull Map<Float, ? extends V2> map);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Map<Float, ? extends V2> map1,
            @Nonnull Map<Float, ? extends V2> map2,
            @Nonnull Map<Float, ? extends V2> map3,
            @Nonnull Map<Float, ? extends V2> map4,
            @Nonnull Map<Float, ? extends V2> map5);



    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.FloatObjConsumer<V2>> entriesSupplier
            );

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            @Nonnull float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(
            @Nonnull Float[] keys, @Nonnull V2[] values);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMap(@Nonnull Iterable<Float> keys,
            @Nonnull Iterable<? extends V2> values);


    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4);

    @Override
    @Nonnull
    <V2 extends V> HashFloatObjMap<V2> newImmutableMapOf(float k1, V2 v1,
            float k2, V2 v2, float k3, V2 v3,
            float k4, V2 v4, float k5, V2 v5);
}
