/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashDoubleFloatMap}s.
 *
 * @see HashDoubleFloatMap
 * @see HashDoubleFloatMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashDoubleFloatMapFactory
        extends DoubleFloatMapFactory<HashDoubleFloatMapFactory>
        , HashContainerFactory<HashDoubleFloatMapFactory>{


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap();

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(
            @Nonnull double[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(
            @Nonnull Map<Double, Float> map);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5);



    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(
            @Nonnull double[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMapOf(double k1, float v1);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
    @Nonnull
     HashDoubleFloatMap newMutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(
            @Nonnull Map<Double, Float> map);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5);



    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(
            @Nonnull double[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
    @Nonnull
     HashDoubleFloatMap newUpdatableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);

    


    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(
            @Nonnull Map<Double, Float> map);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Map<Double, Float> map1,
            @Nonnull Map<Double, Float> map2,
            @Nonnull Map<Double, Float> map3,
            @Nonnull Map<Double, Float> map4,
            @Nonnull Map<Double, Float> map5);



    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.DoubleFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(
            @Nonnull double[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(
            @Nonnull Double[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMap(@Nonnull Iterable<Double> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4);

    @Override
    @Nonnull
     HashDoubleFloatMap newImmutableMapOf(double k1, float v1,
            double k2, float v2, double k3, float v3,
            double k4, float v4, double k5, float v5);
}
