/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashCharFloatMap}s.
 *
 * @see HashCharFloatMap
 * @see HashCharFloatMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashCharFloatMapFactory
        extends CharFloatMapFactory<HashCharFloatMapFactory>
        , CharHashFactory<HashCharFloatMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashCharFloatMap newMutableMap();

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(
            @Nonnull char[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(
            @Nonnull Map<Character, Float> map);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5);



    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(
            @Nonnull char[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashCharFloatMap newMutableMapOf(char k1, float v1);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
    @Nonnull
     HashCharFloatMap newMutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap();

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(
            @Nonnull Map<Character, Float> map);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5);



    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(
            @Nonnull char[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMapOf(char k1, float v1);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
    @Nonnull
     HashCharFloatMap newUpdatableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);

    


    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5, int expectedSize);



    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values, int expectedSize);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values, int expectedSize);

    

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(
            @Nonnull Map<Character, Float> map);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Map<Character, Float> map1,
            @Nonnull Map<Character, Float> map2,
            @Nonnull Map<Character, Float> map3,
            @Nonnull Map<Character, Float> map4,
            @Nonnull Map<Character, Float> map5);



    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.CharFloatConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(
            @Nonnull char[] keys, @Nonnull float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(
            @Nonnull Character[] keys, @Nonnull Float[] values);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMap(@Nonnull Iterable<Character> keys,
            @Nonnull Iterable<Float> values);


    @Override
    @Nonnull
     HashCharFloatMap newImmutableMapOf(char k1, float v1);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4);

    @Override
    @Nonnull
     HashCharFloatMap newImmutableMapOf(char k1, float v1,
            char k2, float v2, char k3, float v3,
            char k4, float v4, char k5, float v5);
}
