/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class MemFileChannel
extends FileChannel {
    private static final byte[][] EMPTY_DATA = new byte[0][];
    private static final int CHUNK_SIZE = 4096;
    private static final int INIT_CHUNKS = 128;
    private long _position;
    private long _size;
    private byte[][] _data;

    private MemFileChannel() {
        this(0L, 0L, EMPTY_DATA);
    }

    private MemFileChannel(long position, long size, byte[][] data) {
        this._position = position;
        this._size = size;
        this._data = data;
    }

    public static MemFileChannel newChannel() {
        return new MemFileChannel();
    }

    public static MemFileChannel newChannel(File file) throws IOException {
        return MemFileChannel.newChannel(file, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemFileChannel newChannel(File file, String mode) throws IOException {
        MemFileChannel memFileChannel;
        FileChannel in = null;
        try {
            in = new RandomAccessFile(file, "r").getChannel();
            memFileChannel = MemFileChannel.newChannel(in, mode);
        }
        catch (Throwable throwable) {
            ByteUtil.closeQuietly(in);
            throw throwable;
        }
        ByteUtil.closeQuietly(in);
        return memFileChannel;
    }

    public static MemFileChannel newChannel(InputStream in) throws IOException {
        return MemFileChannel.newChannel(in, "rw");
    }

    public static MemFileChannel newChannel(InputStream in, String mode) throws IOException {
        return MemFileChannel.newChannel(Channels.newChannel(in), mode);
    }

    public static MemFileChannel newChannel(ReadableByteChannel in) throws IOException {
        return MemFileChannel.newChannel(in, "rw");
    }

    public static MemFileChannel newChannel(ReadableByteChannel in, String mode) throws IOException {
        MemFileChannel channel = new MemFileChannel();
        channel.transferFrom(in, 0L, Long.MAX_VALUE);
        if (!mode.contains("w")) {
            channel = new ReadOnlyChannel(channel);
        }
        return channel;
    }

    public int read(ByteBuffer dst) throws IOException {
        int bytesRead = this.read(dst, this._position);
        if (bytesRead > 0) {
            this._position += (long)bytesRead;
        }
        return bytesRead;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        int numBytes;
        if (position >= this._size) {
            return -1;
        }
        int rem = numBytes = (int)Math.min((long)dst.remaining(), this._size - position);
        while (rem > 0) {
            byte[] chunk = this._data[MemFileChannel.getChunkIndex(position)];
            int chunkOffset = MemFileChannel.getChunkOffset(position);
            int bytesRead = Math.min(rem, 4096 - chunkOffset);
            dst.put(chunk, chunkOffset, bytesRead);
            rem -= bytesRead;
            position += (long)bytesRead;
        }
        return numBytes;
    }

    public int write(ByteBuffer src) throws IOException {
        int bytesWritten = this.write(src, this._position);
        this._position += (long)bytesWritten;
        return bytesWritten;
    }

    public int write(ByteBuffer src, long position) throws IOException {
        int numBytes = src.remaining();
        long newSize = position + (long)numBytes;
        this.ensureCapacity(newSize);
        int rem = numBytes;
        while (rem > 0) {
            byte[] chunk = this._data[MemFileChannel.getChunkIndex(position)];
            int chunkOffset = MemFileChannel.getChunkOffset(position);
            int bytesWritten = Math.min(rem, 4096 - chunkOffset);
            src.get(chunk, chunkOffset, bytesWritten);
            rem -= bytesWritten;
            position += (long)bytesWritten;
        }
        if (newSize > this._size) {
            this._size = newSize;
        }
        return numBytes;
    }

    public long position() throws IOException {
        return this._position;
    }

    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("negative position");
        }
        this._position = newPosition;
        return this;
    }

    public long size() throws IOException {
        return this._size;
    }

    public FileChannel truncate(long newSize) throws IOException {
        if (newSize < 0L) {
            throw new IllegalArgumentException("negative size");
        }
        if (newSize < this._size) {
            for (int i = MemFileChannel.getNumChunks(newSize); i < MemFileChannel.getNumChunks(this._size); ++i) {
                this._data[i] = null;
            }
            this._size = newSize;
        }
        this._position = Math.min(newSize, this._position);
        return this;
    }

    public void force(boolean metaData) throws IOException {
    }

    public long transferTo(WritableByteChannel dst) throws IOException {
        return this.transferTo(0L, this._size, dst);
    }

    public long transferTo(long position, long count, WritableByteChannel dst) throws IOException {
        if (position >= this._size) {
            return 0L;
        }
        count = Math.min(count, this._size - position);
        int chunkIndex = MemFileChannel.getChunkIndex(position);
        int chunkOffset = MemFileChannel.getChunkOffset(position);
        long numBytes = 0L;
        while (count > 0L) {
            int chunkBytes = (int)Math.min(count, (long)(4096 - chunkOffset));
            ByteBuffer src = ByteBuffer.wrap(this._data[chunkIndex], chunkOffset, chunkBytes);
            do {
                int bytesWritten;
                if ((long)(bytesWritten = dst.write(src)) == 0L) {
                    return numBytes;
                }
                numBytes += (long)bytesWritten;
                count -= (long)bytesWritten;
            } while (src.hasRemaining());
            ++chunkIndex;
            chunkOffset = 0;
        }
        return numBytes;
    }

    public long transferTo(OutputStream dst) throws IOException {
        return this.transferTo(0L, this._size, dst);
    }

    public long transferTo(long position, long count, OutputStream dst) throws IOException {
        return this.transferTo(position, count, Channels.newChannel(dst));
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        int chunkIndex = MemFileChannel.getChunkIndex(position);
        int chunkOffset = MemFileChannel.getChunkOffset(position);
        long numBytes = 0L;
        while (count > 0L) {
            this.ensureCapacity(position + numBytes + 1L);
            int chunkBytes = (int)Math.min(count, (long)(4096 - chunkOffset));
            ByteBuffer dst = ByteBuffer.wrap(this._data[chunkIndex], chunkOffset, chunkBytes);
            do {
                int bytesRead;
                if ((bytesRead = src.read(dst)) <= 0) {
                    return numBytes;
                }
                count -= (long)bytesRead;
                this._size = Math.max(this._size, position + (numBytes += (long)bytesRead));
            } while (dst.hasRemaining());
            ++chunkIndex;
            chunkOffset = 0;
        }
        return numBytes;
    }

    protected void implCloseChannel() throws IOException {
        this._data = EMPTY_DATA;
        this._position = 0L;
        this._size = 0L;
    }

    private void ensureCapacity(long newSize) {
        if (newSize <= this._size) {
            return;
        }
        int newNumChunks = MemFileChannel.getNumChunks(newSize);
        int numChunks = MemFileChannel.getNumChunks(this._size);
        if (newNumChunks > this._data.length) {
            int newDataLen;
            for (newDataLen = Math.max(this._data.length, 128); newDataLen < newNumChunks; newDataLen <<= 1) {
            }
            byte[][] newData = new byte[newDataLen][];
            System.arraycopy(this._data, 0, newData, 0, numChunks);
            this._data = newData;
        }
        for (int i = numChunks; i < newNumChunks; ++i) {
            this._data[i] = new byte[4096];
        }
    }

    private static int getChunkIndex(long pos) {
        return (int)(pos / 4096L);
    }

    private static int getChunkOffset(long pos) {
        return (int)(pos % 4096L);
    }

    private static int getNumChunks(long size) {
        return MemFileChannel.getChunkIndex(size + 4096L - 1L);
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long numBytes = 0L;
        for (int i = offset; i < offset + length; ++i) {
            numBytes += (long)this.write(srcs[i]);
        }
        return numBytes;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long numBytes = 0L;
        for (int i = offset; i < offset + length; ++i) {
            if (this._position >= this._size) {
                return numBytes > 0L ? numBytes : -1L;
            }
            numBytes += (long)this.read(dsts[i]);
        }
        return numBytes;
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static final class ReadOnlyChannel
    extends MemFileChannel {
        private ReadOnlyChannel(MemFileChannel channel) {
            super(channel._position, channel._size, channel._data);
        }

        public int write(ByteBuffer src, long position) throws IOException {
            throw new NonWritableChannelException();
        }

        public FileChannel truncate(long newSize) throws IOException {
            throw new NonWritableChannelException();
        }

        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            throw new NonWritableChannelException();
        }
    }
}

