/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.handler.e4;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoHistoryException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.ui.workbench.handler.e4.SessionUndoHandler;
import org.simantics.ui.workbench.handler.e4.UndoRedoTester;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SessionRedoHandler {
    private final boolean DEBUG = false;

    @CanExecute
    public boolean canExecute() {
        return UndoRedoTester.canRedo();
    }

    @Execute
    public void execute(@Active MPart activePart) throws ExecutionException {
        if (activePart == null) {
            return;
        }
        final Session session = Simantics.peekSession();
        if (session == null) {
            return;
        }
        try {
            final AtomicReference msg = new AtomicReference();
            IRunnableWithProgress redo = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Redo", -1);
                            msg.set(SessionRedoHandler.this.redo(session));
                        }
                        catch (NoHistoryException noHistoryException) {
                            msg.set("Nothing to redo.");
                            monitor.done();
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(true, false, redo);
            IWorkbenchPart part = WorkbenchUtils.getActiveWorkbenchPart();
            IStatusLineManager manager = WorkbenchUtils.getStatusLine((IWorkbenchPart)part);
            manager.setMessage((String)msg.get());
        }
        catch (InvocationTargetException e1) {
            throw new ExecutionException("Redo failed, database failure.", e1.getTargetException());
        }
        catch (InterruptedException e1) {
            throw new ExecutionException("Redo failed, interrupted.", (Throwable)e1);
        }
    }

    private String redo(Session session) throws DatabaseException {
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.redo(session, 1);
        if (ops.isEmpty()) {
            return "Nothing to redo.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        String msg = null;
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        for (ChangeSetIdentifier id : management.getChangeSetIdentifiers(csId, csId)) {
            if (msg != null) continue;
            msg = "Redid: " + SessionUndoHandler.getComment(session, id);
        }
        return msg;
    }
}

