/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.templates;

import java.io.IOException;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.store.PreValueStore;
import org.simantics.graph.compiler.internal.templates.ITemplate;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.store.GraphStore;

public enum LoadStringTemplate implements ITemplate
{
    INSTANCE;


    @Override
    public void apply(IGraph graph, GraphStore store, int[] parameters, ExternalFileLoader fileLoader, Collection<Problem> problems) {
        String fileName = ((PreValueStore)store.getStore(PreValueStore.class)).getStringValue(parameters[1]);
        if (fileName == null) {
            Location location = ((LocationStore)store.getStore(LocationStore.class)).getLocation(parameters[1]);
            problems.add(new Problem(location, "Expected a string"));
        }
        try {
            byte[] data = fileLoader.load(fileName);
            store.values.setValue(parameters[0], new Variant((Binding)Bindings.STRING, (Object)new String(data, "UTF-8")));
        }
        catch (IOException e) {
            Location location = ((LocationStore)store.getStore(LocationStore.class)).getLocation(parameters[1]);
            problems.add(new Problem(location, e.getMessage()));
        }
    }
}

