/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.auth;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.request.Read;
import org.simantics.utils.bytes.Base64;

public final class UserAuthenticators {
    public static UserAuthenticator byNameAndPassword(String userName, String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            String localDigest = Base64.encode((byte[])digest.digest(password.getBytes("US-ASCII"))).replace("\n", "").replace("\r", "");
            String reversePassword = new StringBuilder(password).reverse().toString();
            String remoteDigest = Base64.encode((byte[])digest.digest(reversePassword.getBytes("US-ASCII"))).replace("\n", "").replace("\r", "");
            return new Digest(userName, localDigest, remoteDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error("The JVM is required to support UTF-8 and US-ASCII encodings.");
        }
    }

    private static class Digest
    implements UserAuthenticator {
        private final String userName;
        private final String localDigest;
        private final String remoteDigest;

        Digest(String userName, String localDigest, String remoteDigest) {
            this.userName = userName;
            this.localDigest = localDigest;
            this.remoteDigest = remoteDigest;
        }

        public Resource getUser(RequestProcessor processor) throws InvalidUserException, InvalidAuthenticationException {
            try {
                Resource user = (Resource)processor.syncRequest((Read)new Read<Resource>(){

                    public Resource perform(ReadGraph graph) throws DatabaseException {
                        Resource userLibrary = graph.getResource("http://Users");
                        Resource consistsOf = graph.getResource("http://www.simantics.org/Layer0-1.1/ConsistsOf");
                        Resource hasName = graph.getResource("http://www.simantics.org/Layer0-1.1/HasLabel");
                        Resource hasPasswordHash = graph.getResource("http://www.simantics.org/User-1.1/HasPasswordHash");
                        for (Resource r : graph.getObjects(userLibrary, consistsOf)) {
                            try {
                                String name = (String)graph.getRelatedValue(r, hasName, (Binding)Bindings.STRING);
                                if (!name.equals(userName)) continue;
                                String graphDigest = (String)graph.getRelatedValue(r, hasPasswordHash, Bindings.getBinding(String.class));
                                if (graphDigest.equals(localDigest)) {
                                    return r;
                                }
                                throw new InvalidAuthenticationException("Password was not valid for user '" + userName + "'");
                            }
                            catch (BindingConstructionException e) {
                                throw new DatabaseException((Throwable)e);
                            }
                        }
                        throw new InvalidUserException("User '" + userName + "' was not found.");
                    }
                });
                return user;
            }
            catch (InvalidAuthenticationException e) {
                throw e;
            }
            catch (InvalidUserException e) {
                throw e;
            }
            catch (DatabaseException e) {
                throw new InvalidAuthenticationException("Authentication failed, see cause for details.", (Throwable)e);
            }
        }

        public String userName() {
            return this.userName;
        }

        public String remoteDigest() {
            return this.remoteDigest;
        }
    }
}

