/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

public class AllIssues
extends BinaryRead<Resource, Boolean, Set<Resource>> {
    public AllIssues(Resource project) {
        super((Object)project, (Object)Boolean.FALSE);
    }

    public AllIssues(Resource project, boolean onlyUnresolved) {
        super((Object)project, (Object)onlyUnresolved);
    }

    public void collectIssuesFrom(ReadGraph graph, Resource container, Set<Resource> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType(container, L0.ConsistsOf, ISSUE.Issue))) {
            if (((Boolean)this.parameter2).booleanValue() && graph.hasStatement(issue, ISSUE.Resolved)) continue;
            result.add(issue);
        }
    }

    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        Set result = cs.createSet();
        Instances indexedIssues = (Instances)graph.getPossibleAdapter(ISSUE.Issue, Instances.class);
        for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, SIMU.Model))) {
            this.collectIssuesFrom(graph, model, result);
            for (Resource source : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, ISSUE.IssueSource))) {
                this.collectIssuesFrom(graph, source, result);
            }
            if (indexedIssues == null) continue;
            result.addAll(indexedIssues.find(graph, model));
        }
        return result;
    }
}

