/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.server.environment.windows;

public enum ProductState {
    INVALIDARG(-2),
    UNKNOWN(-1),
    FAILED(0),
    ADVERTISED(1),
    ABSENT(2),
    DEFAULT(5);

    int code;

    private ProductState(int code) {
        this.code = code;
    }

    public static ProductState of(int code) {
        switch (code) {
            case -2: {
                return INVALIDARG;
            }
            case -1: {
                return UNKNOWN;
            }
            case 0: {
                return FAILED;
            }
            case 1: {
                return ADVERTISED;
            }
            case 2: {
                return ABSENT;
            }
            case 5: {
                return DEFAULT;
            }
        }
        throw new IllegalArgumentException("unrecognized product install state return code: " + code);
    }

    public String toString() {
        return String.valueOf(this.name()) + "(" + this.code + ")";
    }
}

