/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.server.environment.windows;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.simantics.db.procore.server.environment.ExecutionEnvironment;
import org.simantics.db.procore.server.environment.ExecutionEnvironmentException;
import org.simantics.db.procore.server.environment.windows.Product;
import org.simantics.db.procore.server.environment.windows.ProductState;

public class Msi {
    private static final String DLL_NAME = "msijni.dll";
    private static final String DLL_NAME_64 = "msijni64.dll";

    static {
        Msi.initialize();
    }

    public static void checkOneOfProductsInstalled(Product ... products) throws ExecutionEnvironmentException {
        StringBuilder sb = new StringBuilder();
        sb.append("None of the following products are installed properly:\n");
        Product[] productArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            ProductState state = Msi.MsiQueryProductState(product.getCode());
            switch (state) {
                case DEFAULT: {
                    return;
                }
            }
            sb.append("\t" + product);
            sb.append(" - MsiQueryProductState returned ");
            sb.append((Object)state);
            sb.append("\n");
            ++n2;
        }
        throw new ExecutionEnvironmentException("Cannot run ProCore database server in this environment due to the following problems:\n" + sb.toString(), Arrays.asList(products));
    }

    public static void checkProductsInstalled(Product ... products) throws ExecutionEnvironmentException {
        StringBuilder sb = new StringBuilder();
        Product[] productArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            ProductState state = Msi.MsiQueryProductState(product.getCode());
            switch (state) {
                case DEFAULT: {
                    break;
                }
                default: {
                    sb.append("\tProduct " + product + " is not installed properly, MsiQueryProductState returned " + (Object)((Object)state));
                    sb.append("\n");
                }
            }
            ++n2;
        }
        if (sb.length() > 0) {
            throw new ExecutionEnvironmentException("Cannot run ProCore database server in this environment due to the following problems:\n" + sb.toString(), Arrays.asList(products));
        }
    }

    public static ProductState MsiQueryProductState(String productCode) {
        int result = Msi.MsiQueryProductState0(productCode);
        return ProductState.of(result);
    }

    private static native int MsiQueryProductState0(String var0);

    private static void initialize() {
        ExecutionEnvironment env = ExecutionEnvironment.calculate();
        String libName = null;
        switch (env.arch) {
            case X86: {
                libName = DLL_NAME;
                break;
            }
            case X86_64: {
                libName = DLL_NAME_64;
                break;
            }
            default: {
                return;
            }
        }
        URL libURL = Msi.class.getResource("/" + libName);
        if (libURL != null) {
            try {
                if ("file".equals(libURL.getProtocol())) {
                    File path = new File(URLDecoder.decode(libURL.getPath(), "UTF-8"));
                    Msi.initialize(path);
                } else {
                    File libFile = Msi.extractLib(libURL, libName);
                    Msi.initialize(libFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void initialize(File path) {
        System.load(path.toString());
    }

    private static File copyResource(URL url, File targetFile) throws IOException, FileNotFoundException {
        File file;
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int read;
            if (targetFile.exists()) {
                targetFile.delete();
            }
            is = url.openStream();
            byte[] buffer = new byte[16384];
            os = new FileOutputStream(targetFile);
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.close();
            is.close();
            file = targetFile;
        }
        catch (Throwable throwable) {
            Msi.uncheckedClose(os);
            Msi.uncheckedClose(is);
            throw throwable;
        }
        Msi.uncheckedClose(os);
        Msi.uncheckedClose(is);
        return file;
    }

    private static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    private static File extractLib(URL libURL, String libName) throws FileNotFoundException, IOException {
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            throw new NullPointerException("java.io.tmpdir property is null");
        }
        File tmpDir = new File(tmpDirStr);
        File libFile = new File(tmpDir, libName);
        if (libFile.exists() && libFile.isFile()) {
            try {
                byte[] origSum = Msi.computeSum(libURL);
                byte[] targetSum = Msi.computeSum(libFile);
                if (Arrays.equals(origSum, targetSum)) {
                    return libFile;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return Msi.copyResource(libURL, libFile);
    }

    public static byte[] computeSum(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] data = new byte[65536];
            while (true) {
                int read;
                if ((read = in.read(data)) == -1) {
                    return md.digest();
                }
                md.update(data, 0, read);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static byte[] computeSum(File f) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream in = null;){
            in = new FileInputStream(f);
            byte[] byArray = Msi.computeSum(in);
            return byArray;
        }
    }

    public static byte[] computeSum(URL url) throws IOException, NoSuchAlgorithmException {
        try (InputStream in = null;){
            in = url.openStream();
            byte[] byArray = Msi.computeSum(in);
            return byArray;
        }
    }
}

