/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.ui.widgets.ITrackedColorProvider;
import org.simantics.utils.ui.widgets.TrackedCaretListener;
import org.simantics.utils.ui.widgets.TrackedModifyEvent;
import org.simantics.utils.ui.widgets.TrackedModifyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackedStyledText {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackedStyledText.class);
    private static final int EDITING = 1;
    private static final int MODIFIED_DURING_EDITING = 2;
    private static final int MOUSE_DOWN_FIRST_TIME = 4;
    private static final int MOUSE_INSIDE_CONTROL = 8;
    private int state;
    private int caretPositionBeforeEdit;
    private String textBeforeEdit;
    private final StyledText text;
    private CompositeListener listener;
    private ListenerList caretListeners;
    private ListenerList modifyListeners;
    private IInputValidator validator;
    private ITrackedColorProvider colorProvider;
    private ResourceManager resourceManager;

    public TrackedStyledText(StyledText text) {
        Assert.isNotNull((Object)text);
        this.state = 0;
        this.text = text;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)text);
        this.colorProvider = new DefaultColorProvider();
        this.initialize();
    }

    public TrackedStyledText(Composite parent, int style) {
        this.state = 0;
        this.text = new StyledText(parent, style);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.text);
        this.colorProvider = new DefaultColorProvider();
        this.initialize();
    }

    public TrackedStyledText(StyledText text, ITrackedColorProvider colorProvider) {
        Assert.isNotNull((Object)text, (String)"text must not be null");
        Assert.isNotNull((Object)colorProvider, (String)"colorProvider must not be null");
        this.state = 0;
        this.text = text;
        this.colorProvider = colorProvider;
        this.initialize();
    }

    public TrackedStyledText(Composite parent, int style, ITrackedColorProvider colorProvider) {
        Assert.isNotNull((Object)colorProvider, (String)"colorProvider must not be null");
        this.state = 0;
        this.text = new StyledText(parent, style);
        this.colorProvider = colorProvider;
        this.initialize();
    }

    private void initialize() {
        Assert.isNotNull((Object)this.text);
        this.text.setBackground(this.colorProvider.getInactiveBackground());
        this.text.setDoubleClickEnabled(false);
        this.listener = new CompositeListener();
        this.text.addModifyListener((ModifyListener)this.listener);
        this.text.addDisposeListener((DisposeListener)this.listener);
        this.text.addKeyListener((KeyListener)this.listener);
        this.text.addMouseTrackListener((MouseTrackListener)this.listener);
        this.text.addMouseListener((MouseListener)this.listener);
        this.text.addFocusListener((FocusListener)this.listener);
        this.text.addCaretListener((CaretListener)this.listener);
    }

    private void startEdit(boolean selectAll) {
        if (this.isEditing()) {
            System.out.println("TrackedText: BUG: startEdit called when in editing state");
        }
        System.out.println("start edit: selectall=" + selectAll + ", text=" + this.text.getText() + ", caretpos=" + this.caretPositionBeforeEdit);
        this.caretPositionBeforeEdit = this.text.getCaretOffset();
        this.textBeforeEdit = this.text.getText();
        this.setBackground(this.colorProvider.getEditingBackground());
        if (selectAll) {
            this.text.selectAll();
        }
        this.state |= 5;
    }

    private void applyEdit() {
        LOGGER.info("apply edit");
        try {
            if (this.isTextValid() != null) {
                this.text.setText(this.textBeforeEdit);
            } else if (this.isModified() && !this.text.getText().equals(this.textBeforeEdit) && this.modifyListeners != null) {
                TrackedModifyEvent event = new TrackedModifyEvent((Widget)this.text, this.text.getText());
                Object[] objectArray = this.modifyListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    ((TrackedModifyListener)o).modifyText(event);
                    ++n2;
                }
            }
        }
        finally {
            this.endEdit();
        }
    }

    private void fireCaretListeners() {
        if (this.caretListeners != null) {
            Object[] objectArray = this.caretListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((TrackedCaretListener)o).caretOrSelectionChanged();
                ++n2;
            }
        }
    }

    private void endEdit() {
        LOGGER.info("endedit");
        if (!this.isEditing()) {
            System.out.println();
        }
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    private void revertEdit() {
        if (!this.isEditing()) {
            LOGGER.warn("BUG: revertEdit called when not in editing state");
        }
        this.text.setText(this.textBeforeEdit);
        this.text.setSelection(this.caretPositionBeforeEdit);
        this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        this.state &= 0xFFFFFFFA;
        this.setModified(false);
    }

    public boolean isEditing() {
        return (this.state & 1) != 0;
    }

    private void setModified(boolean modified) {
        this.state = modified ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
    }

    private boolean isMouseInsideControl() {
        return (this.state & 8) != 0;
    }

    private void setMouseInsideControl(boolean inside) {
        this.state = inside ? (this.state |= 8) : (this.state &= 0xFFFFFFF7);
    }

    public boolean isModified() {
        return (this.state & 2) != 0;
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.text.setEditable(true);
            this.setBackground(this.isMouseInsideControl() ? this.colorProvider.getHoverBackground() : this.colorProvider.getInactiveBackground());
        } else {
            this.text.setEditable(false);
            this.text.setBackground(null);
        }
    }

    public void setText(String text) {
        this.text.setText(text);
    }

    public void setTextWithoutNotify(String text) {
        this.text.removeModifyListener((ModifyListener)this.listener);
        this.setText(text);
        this.text.addModifyListener((ModifyListener)this.listener);
    }

    public StyledText getWidget() {
        return this.text;
    }

    public synchronized void addModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            this.modifyListeners = new ListenerList(1);
        }
        this.modifyListeners.add((Object)listener);
    }

    public synchronized void addCaretListener(TrackedCaretListener listener) {
        if (this.caretListeners == null) {
            this.caretListeners = new ListenerList(1);
        }
        this.caretListeners.add((Object)listener);
    }

    public synchronized void removeModifyListener(TrackedModifyListener listener) {
        if (this.modifyListeners == null) {
            return;
        }
        this.modifyListeners.remove((Object)listener);
    }

    public synchronized void removeCaretListener(TrackedCaretListener listener) {
        if (this.caretListeners == null) {
            return;
        }
        this.caretListeners.remove((Object)listener);
    }

    public void setInputValidator(IInputValidator validator) {
        if (validator != this.validator) {
            this.validator = validator;
        }
    }

    private String isTextValid() {
        if (this.validator != null) {
            return this.validator.isValid(this.getWidget().getText());
        }
        return null;
    }

    public void setColorProvider(ITrackedColorProvider provider) {
        Assert.isNotNull((Object)provider);
        this.colorProvider = provider;
    }

    private void setBackground(Color background) {
        if (!this.text.getEditable()) {
            return;
        }
        this.text.setBackground(background);
    }

    private class CompositeListener
    implements ModifyListener,
    DisposeListener,
    KeyListener,
    MouseTrackListener,
    MouseListener,
    FocusListener,
    CaretListener {
        private CompositeListener() {
        }

        public void modifyText(ModifyEvent e) {
            TrackedStyledText.this.setModified(true);
            String valid = TrackedStyledText.this.isTextValid();
            if (valid != null) {
                TrackedStyledText.this.setBackground(TrackedStyledText.this.colorProvider.getInvalidBackground());
            } else if (TrackedStyledText.this.isEditing()) {
                TrackedStyledText.this.setBackground(TrackedStyledText.this.colorProvider.getEditingBackground());
            } else {
                TrackedStyledText.this.setBackground(TrackedStyledText.this.colorProvider.getInactiveBackground());
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TrackedStyledText.this.getWidget().removeModifyListener((ModifyListener)this);
        }

        private boolean isMultiLine() {
            return (TrackedStyledText.this.text.getStyle() & 2) != 0;
        }

        private boolean hasMultiLineCommitModifier(KeyEvent e) {
            return (e.stateMask & 0x40000) != 0;
        }

        public void keyPressed(KeyEvent e) {
            if (!TrackedStyledText.this.isEditing()) {
                if (e.keyCode == 27) {
                    return;
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 0x100000B || e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedStyledText.this.startEdit(true);
                    } else if (e.character != '\u0000') {
                        TrackedStyledText.this.startEdit(false);
                    }
                } else if (e.keyCode == 0x100000B) {
                    TrackedStyledText.this.startEdit(true);
                } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    if (this.hasMultiLineCommitModifier(e)) {
                        e.doit = false;
                    } else {
                        TrackedStyledText.this.startEdit(false);
                    }
                } else if (e.keyCode == 9) {
                    TrackedStyledText.this.text.traverse((e.stateMask & 0x20000) != 0 ? 8 : 16);
                    e.doit = false;
                } else if (e.character != '\u0000') {
                    TrackedStyledText.this.startEdit(false);
                }
            } else {
                if (e.keyCode == 27) {
                    TrackedStyledText.this.revertEdit();
                }
                if (!this.isMultiLine()) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TrackedStyledText.this.applyEdit();
                    }
                } else if ((e.keyCode == 13 || e.keyCode == 0x1000050) && this.hasMultiLineCommitModifier(e)) {
                    TrackedStyledText.this.applyEdit();
                    e.doit = false;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseEnter(MouseEvent e) {
            if (!TrackedStyledText.this.isEditing()) {
                TrackedStyledText.this.setBackground(TrackedStyledText.this.colorProvider.getHoverBackground());
            }
            TrackedStyledText.this.setMouseInsideControl(true);
        }

        public void mouseExit(MouseEvent e) {
            if (!TrackedStyledText.this.isEditing()) {
                TrackedStyledText.this.setBackground(TrackedStyledText.this.colorProvider.getInactiveBackground());
            }
            TrackedStyledText.this.setMouseInsideControl(false);
        }

        public void mouseHover(MouseEvent e) {
            TrackedStyledText.this.setMouseInsideControl(true);
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                TrackedStyledText.this.getWidget().selectAll();
            }
        }

        public void mouseDown(MouseEvent e) {
            if (!TrackedStyledText.this.isEditing()) {
                if (e.button == 1) {
                    TrackedStyledText.this.startEdit(false);
                }
            } else if (e.button == 1 && (TrackedStyledText.this.state & 4) != 0) {
                TrackedStyledText.this.getWidget().selectAll();
                TrackedStyledText trackedStyledText = TrackedStyledText.this;
                trackedStyledText.state = trackedStyledText.state & 0xFFFFFFFB;
            }
        }

        public void mouseUp(MouseEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (!TrackedStyledText.this.isEditing() && !this.isMultiLine()) {
                TrackedStyledText.this.startEdit(true);
            }
        }

        public void focusLost(FocusEvent e) {
            if (TrackedStyledText.this.isEditing()) {
                TrackedStyledText.this.applyEdit();
            }
        }

        public void caretMoved(CaretEvent event) {
            TrackedStyledText.this.fireCaretListeners();
        }
    }

    private class DefaultColorProvider
    implements ITrackedColorProvider {
        private final ColorDescriptor highlightColor = ColorDescriptor.createFrom((RGB)new RGB(254, 255, 197));
        private final ColorDescriptor inactiveColor = ColorDescriptor.createFrom((RGB)new RGB(245, 246, 190));
        private final ColorDescriptor invalidInputColor = ColorDescriptor.createFrom((RGB)new RGB(255, 128, 128));

        private DefaultColorProvider() {
        }

        @Override
        public Color getEditingBackground() {
            return null;
        }

        @Override
        public Color getHoverBackground() {
            return TrackedStyledText.this.resourceManager.createColor(this.highlightColor);
        }

        @Override
        public Color getInactiveBackground() {
            return TrackedStyledText.this.resourceManager.createColor(this.inactiveColor);
        }

        @Override
        public Color getInvalidBackground() {
            return TrackedStyledText.this.resourceManager.createColor(this.invalidInputColor);
        }
    }
}

