/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

class SumifFormulaFunction
implements CellFormulaFunction<Object> {
    SumifFormulaFunction() {
    }

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 2) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            }
            catch (IllegalStateException illegalStateException) {
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if (error != null) {
                return error.getString();
            }
            if (test instanceof SpreadsheetMatrix) {
                double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix)test;
                int i = 0;
                while (i < tm.values.length) {
                    double d;
                    if (SpreadsheetGraphUtils.matchCriteria(tm.values[i], criteria) && Double.isFinite(d = SpreadsheetGraphUtils.asNumber(tm.values[i]))) {
                        sum += d;
                    }
                    ++i;
                }
                return sum;
            }
            Double d = SpreadsheetGraphUtils.asNumber(test);
            return d;
        }
        if (args.values.size() == 3) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            }
            catch (IllegalStateException illegalStateException) {
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if (error != null) {
                return error.getString();
            }
            Object range = args.values.get(2).accept(visitor);
            if (test instanceof SpreadsheetMatrix) {
                Double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix)test;
                SpreadsheetMatrix rm = (SpreadsheetMatrix)range;
                int i = 0;
                while (i < tm.values.length) {
                    double d;
                    if (SpreadsheetGraphUtils.matchCriteria(tm.values[i], criteria) && Double.isFinite(d = SpreadsheetGraphUtils.asNumber(rm.values[i]))) {
                        sum = sum + d;
                    }
                    ++i;
                }
                return sum;
            }
            Double d = SpreadsheetGraphUtils.asNumber(test);
            return d;
        }
        throw new IllegalStateException();
    }
}

