/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.comparators;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.comparators.ImmutableLexicalComparable;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.Labeler;

public class LexicalComparatorFactory
implements ComparableContextFactory {
    private final String column;
    private final String label;

    public LexicalComparatorFactory(String column) {
        this.column = column;
        this.label = null;
    }

    public LexicalComparatorFactory(String column, String label) {
        this.column = column;
        this.label = label;
    }

    public ComparableContext[] create(NodeQueryManager manager, NodeContext parent, NodeContext[] children) {
        ComparableContext[] result = new ComparableContext[children.length];
        int i = 0;
        while (i < children.length) {
            String label;
            NodeContext child = children[i];
            Labeler labeler = (Labeler)manager.query(child, BuiltinKeys.SELECTED_LABELER);
            int category = labeler != null ? labeler.getCategory() : 0;
            String string = label = labeler != null ? (String)labeler.getLabels().get(this.column) : "";
            if (label == null) {
                label = "";
            }
            result[i] = new ImmutableLexicalComparable(category, label, child){

                public int compareTo(ComparableContext arg0) {
                    ImmutableLexicalComparable other = (ImmutableLexicalComparable)arg0;
                    int catDelta = this.getCategory() - other.getCategory();
                    if (catDelta != 0) {
                        return catDelta;
                    }
                    String label1 = this.getLabel();
                    String label2 = other.getLabel();
                    return label1.compareToIgnoreCase(label2);
                }
            };
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.label != null ? this.label : "Alphabetical";
    }
}

