/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.WriteState;
import fi.vtt.simantics.procore.internal.WriteStateBase;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.simantics.db.Disposable;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.internal.RandomAccessValueSupport;
import org.simantics.db.impl.internal.ResourceData;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionRequestManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionRequestManager.class);
    private static boolean DEBUG = false;
    final SessionImplSocket session;
    final fi.vtt.simantics.procore.internal.State transactionState;
    final LinkedList<QueryProcessor.SessionTask> writes = new LinkedList();
    final LinkedList<QueryProcessor.SessionRead> reads = new LinkedList();
    State state = State.INIT;

    private boolean legal(State current, State target) {
        if (State.IDLE == current) {
            return State.INIT != target && State.WRITE_UPDATE != target && State.READ_UPDATE != target;
        }
        if (State.WRITE == current) {
            return State.WRITE_UPDATE == target;
        }
        if (State.READ == current) {
            return State.READ_UPDATE == target;
        }
        if (State.ERROR == current) {
            return State.IDLE == target;
        }
        return State.IDLE == target;
    }

    private synchronized void setState(int thread, State state, QueryProcessor.SessionTask task) {
        if (DEBUG) {
            System.err.println("Session state: " + (Object)((Object)this.state) + " => " + (Object)((Object)state) + " - " + task);
        }
        if (this.state == state) {
            return;
        }
        assert (this.legal(this.state, state));
        if (State.READ == state) assert (State.IDLE == this.state);
        State oldState = this.state;
        this.state = state;
        if (State.IDLE == oldState && State.IDLE != state) {
            this.session.incAsync();
        }
        if (State.READ == state) {
            this.startRead(thread, (QueryProcessor.SessionRead)task);
        } else if (State.WRITE == state) {
            this.startWrite(thread, task);
        } else if (State.READ == oldState) {
            this.startReadUpdate(thread);
        } else if (State.WRITE == oldState) {
            this.startWriteUpdate(thread);
        }
        if (state == State.IDLE) {
            this.closeRandomAccessValues();
            if (!this.writes.isEmpty()) {
                this.setState(thread, State.WRITE, this.writes.poll());
            } else if (!this.reads.isEmpty()) {
                this.setState(thread, State.READ, (QueryProcessor.SessionTask)this.reads.poll());
            }
            this.session.decAsync();
        }
    }

    public SessionRequestManager(SessionImplSocket session, fi.vtt.simantics.procore.internal.State transactionState) {
        this.session = session;
        this.transactionState = transactionState;
    }

    public synchronized void startRead(int thread, final QueryProcessor.SessionRead task) {
        this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

            public void run0(int thread) {
                try {
                    try {
                        SessionRequestManager.this.transactionState.startReadTransaction(thread);
                        task.run(thread);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Read transaction could not be started", t);
                        if (task.throwable != null) {
                            task.throwable.set((Object)t);
                        }
                        SessionRequestManager.this.state = State.ERROR;
                        if (task.notify != null) {
                            task.notify.release();
                        }
                    }
                }
                finally {
                    if (task.notify != null) {
                        task.notify.release();
                    }
                }
            }
        });
    }

    public synchronized void startReadUpdate(int thread) {
        this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

            public void run0(int thread) {
                SessionRequestManager.this.session.fireFinishReadTransaction();
                try {
                    SessionRequestManager.this.transactionState.stopReadTransaction();
                }
                catch (DatabaseException e) {
                    LOGGER.error("Read transaction could not be stopped", (Throwable)e);
                }
            }
        });
    }

    public synchronized void startWrite(int thread, final QueryProcessor.SessionTask task) {
        this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

            public void run0(int thread) {
                try {
                    SessionRequestManager.this.transactionState.startWriteTransaction(thread);
                }
                catch (Throwable t) {
                    LOGGER.error("Write transaction could not be started", t);
                    return;
                }
                task.run(thread);
            }
        });
    }

    public synchronized void startWriteUpdate(int thread) {
        this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

            public void run0(int thread) {
                WriteStateBase<?> delayedState = SessionRequestManager.this.session.delayedWriteState;
                SessionRequestManager.this.session.delayedWriteState = null;
                if (delayedState != null) {
                    if (SessionRequestManager.this.session.writeState != null) {
                        throw new AssertionError((Object)"Both session delayedWriteState and writeState are set, only one can be set.");
                    }
                    if (delayedState.isExcepted()) {
                        boolean empty = SessionRequestManager.this.session.clusterStream.reallyFlush();
                        if (!$assertionsDisabled && !empty) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new UnsupportedOperationException("delayedWriteState may only exist when request fails.");
                    }
                    SessionRequestManager.this.transactionState.stopWriteTransaction(SessionRequestManager.this.session.clusterStream);
                    Disposable.safeDispose((Disposable)SessionRequestManager.this.session.clientChanges);
                    SessionRequestManager.this.session.clientChanges = new ClientChangesImpl(SessionRequestManager.this.session);
                    delayedState.finish();
                    return;
                }
                if (!SessionRequestManager.this.session.state.isAlive()) {
                    return;
                }
                WriteState<?> writeState = SessionRequestManager.this.session.writeState;
                if (!$assertionsDisabled && writeState == null) {
                    throw new AssertionError();
                }
                WriteGraphImpl graph = writeState.getGraph();
                if (writeState.isExcepted()) {
                    if (!(writeState.exception instanceof CancelTransactionException)) {
                        LOGGER.error("Write request failed", writeState.exception);
                    }
                    SessionRequestManager.this.transactionState.cancelWriteTransaction(graph);
                } else {
                    SessionRequestManager.this.session.handleUpdatesAndMetadata(graph);
                    SessionRequestManager.this.transactionState.commitWriteTransaction(writeState.getGraph(), SessionRequestManager.this.session.clusterStream, SessionRequestManager.this.session.clientChanges, writeState.getRequest(), null);
                }
                Disposable.safeDispose((Disposable)SessionRequestManager.this.session.clientChanges);
                SessionRequestManager.this.session.clientChanges = new ClientChangesImpl(SessionRequestManager.this.session);
                WriteState<?> state = SessionRequestManager.this.session.writeState;
                state.finish();
                SessionRequestManager.this.session.writeState = null;
            }
        });
    }

    public synchronized void ceased(int thread) {
        if (State.WRITE == this.state) {
            this.setState(thread, State.WRITE_UPDATE, null);
        } else if (State.WRITE_UPDATE == this.state) {
            this.setState(thread, State.IDLE, null);
        } else if (State.READ_UPDATE == this.state) {
            this.setState(thread, State.IDLE, null);
        } else if (State.READ == this.state) {
            if (!this.reads.isEmpty()) {
                final QueryProcessor.SessionRead read = this.reads.poll();
                this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

                    public void run0(int thread) {
                        read.run(thread);
                        if (read.notify != null) {
                            read.notify.release();
                        }
                    }
                });
            } else {
                this.setState(thread, State.READ_UPDATE, null);
            }
        } else if (State.INIT == this.state) {
            assert (this.reads.isEmpty());
            assert (this.writes.isEmpty());
            this.setState(thread, State.IDLE, null);
        } else if (State.ERROR == this.state) {
            this.setState(thread, State.IDLE, null);
        }
    }

    public synchronized void scheduleRead(final QueryProcessor.SessionRead task) {
        assert (State.INIT != this.state);
        if (State.READ == this.state) {
            this.session.queryProvider2.schedule(new QueryProcessor.SessionTask(null){

                public void run0(int thread) {
                    try {
                        task.run(thread);
                    }
                    finally {
                        if (task.notify != null) {
                            task.notify.release();
                        }
                    }
                }
            });
        } else if (State.IDLE == this.state) {
            this.setState(Integer.MIN_VALUE, State.READ, (QueryProcessor.SessionTask)task);
        } else {
            this.reads.offer(task);
        }
    }

    public int lastUpdateIndex() {
        return this.writes.size();
    }

    public synchronized void scheduleWrite(QueryProcessor.SessionTask task) {
        this.scheduleWrite(task, null);
    }

    public synchronized void scheduleWrite(QueryProcessor.SessionTask task, Boolean combine) {
        boolean inUpdate;
        boolean bl = inUpdate = this.state == State.WRITE_UPDATE;
        assert (State.INIT != this.state);
        if (State.IDLE == this.state) {
            this.setState(Integer.MIN_VALUE, State.WRITE, task);
        } else if (inUpdate) {
            int index = this.lastUpdateIndex();
            if (index == this.writes.size()) {
                this.writes.offer(task);
            } else {
                this.writes.add(index, task);
            }
        } else {
            this.writes.offer(task);
        }
    }

    private void closeRandomAccessValues() {
        RandomAccessValueSupport ravs = this.session.peekService(RandomAccessValueSupport.class);
        if (ravs == null) {
            return;
        }
        Collection values = ravs.removeAll();
        for (Pair value : values) {
            try {
                ((ResourceData)value.second).binaryFile.close();
            }
            catch (IOException e) {
                LOGGER.error("I/O exception while closing random access value file " + ((ResourceData)value.second).binaryFile.file() + " for resource " + value.first, (Throwable)e);
            }
        }
    }

    static enum State {
        INIT,
        IDLE,
        READ,
        WRITE,
        WRITE_UPDATE,
        READ_UPDATE,
        ERROR;

    }
}

