/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypePropertiesResult;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerData;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerPropertyInfo;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerSection;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerSectionFactory;
import org.simantics.modeling.ui.componentTypeEditor.ConfigurationPropertiesSection;
import org.simantics.modeling.ui.componentTypeEditor.DerivedPropertiesSection;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.SWTUtils;

public class ComponentTypeViewer {
    ComponentTypeViewerData data;
    ResourceManager resourceManager;
    ArrayList<ComponentTypeViewerSection> sections = new ArrayList(3);

    public ComponentTypeViewer(Composite parent, final Resource _componentType, String formTitle) {
        FormToolkit tk = new FormToolkit(parent.getDisplay());
        final Form form = tk.createForm(parent);
        tk.decorateFormHeading(form);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)form);
        form.setText(formTitle);
        form.setImage(this.resourceManager.createImage(Activator.COMPONENT_TYPE_ICON));
        FormLayout layout = new FormLayout();
        layout.marginBottom = 10;
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        form.getBody().setLayout((Layout)layout);
        this.data = new ComponentTypeViewerData(tk, _componentType, form);
        this.sections.add(new ConfigurationPropertiesSection(this.data));
        this.sections.add(new DerivedPropertiesSection(this.data));
        final BundleContext bundleContext = Activator.getContext();
        try {
            ArrayList factories = (ArrayList)Simantics.getSession().syncRequest((Read)new Read<ArrayList<ComponentTypeViewerSectionFactory>>(){

                public ArrayList<ComponentTypeViewerSectionFactory> perform(ReadGraph graph) throws DatabaseException {
                    ArrayList<ComponentTypeViewerSectionFactory> factories = new ArrayList<ComponentTypeViewerSectionFactory>(3);
                    try {
                        String className = ComponentTypeViewerSectionFactory.class.getName();
                        ServiceReference[] references = bundleContext.getAllServiceReferences(className, null);
                        if (references != null) {
                            ServiceReference[] serviceReferenceArray = references;
                            int n = references.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ServiceReference reference = serviceReferenceArray[n2];
                                ComponentTypeViewerSectionFactory factory = (ComponentTypeViewerSectionFactory)bundleContext.getService(reference);
                                if (factory.doesSupport(graph, _componentType)) {
                                    factories.add(factory);
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (InvalidSyntaxException e) {
                        e.printStackTrace();
                    }
                    return factories;
                }
            });
            for (ComponentTypeViewerSectionFactory factory : factories) {
                this.sections.add(factory.create(this.data));
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.sections.sort((a, b) -> Double.compare(a.getPriority(), b.getPriority()));
        Sash[] sashes = new Sash[this.sections.size() - 1];
        int i = 0;
        while (i < this.sections.size() - 1) {
            final Sash sash = new Sash(form.getBody(), 256);
            sash.setBackground(sash.getDisplay().getSystemColor(1));
            FormData data = new FormData();
            data.top = new FormAttachment(100 * (i + 1) / this.sections.size(), 0);
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.height = 10;
            sash.setLayoutData((Object)data);
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    sash.setBounds(e.x, e.y, e.width, e.height);
                    FormData data = new FormData();
                    data.top = new FormAttachment(0, e.y);
                    data.left = new FormAttachment(0, 0);
                    data.right = new FormAttachment(100, 0);
                    data.height = 10;
                    sash.setLayoutData((Object)data);
                    form.getBody().layout(true);
                }
            });
            sashes[i] = sash;
            ++i;
        }
        i = 0;
        while (i < this.sections.size()) {
            FormData formData = new FormData();
            formData.top = i > 0 ? new FormAttachment((Control)sashes[i - 1]) : new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = i < this.sections.size() - 1 ? new FormAttachment((Control)sashes[i]) : new FormAttachment(100, 0);
            this.sections.get(i).getSection().setLayoutData((Object)formData);
            ++i;
        }
        this.createGraphListener();
    }

    private void createGraphListener() {
        Simantics.getSession().asyncRequest((Read)new UniqueRead<ComponentTypePropertiesResult>(){

            public ComponentTypePropertiesResult perform(ReadGraph graph) throws DatabaseException {
                ArrayList<ComponentTypeViewerPropertyInfo> result = new ArrayList<ComponentTypeViewerPropertyInfo>();
                ArrayList<NamedResource> connectionPoints = new ArrayList<NamedResource>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                boolean typeIsImmutable = graph.isImmutable(ComponentTypeViewer.this.data.componentType) || graph.hasStatement(ComponentTypeViewer.this.data.componentType, STR.ComponentType_Locked) || Layer0Utils.isPublished((ReadGraph)graph, (Resource)ComponentTypeViewer.this.data.componentType) || Layer0Utils.isContainerPublished((ReadGraph)graph, (Resource)ComponentTypeViewer.this.data.componentType);
                for (Resource relation : graph.getObjects(ComponentTypeViewer.this.data.componentType, L0.DomainOf)) {
                    if (graph.isSubrelationOf(relation, L0.HasProperty)) {
                        String description;
                        String name = (String)graph.getRelatedValue(relation, L0.HasName);
                        String type = (String)graph.getPossibleRelatedValue(relation, L0.RequiresValueType);
                        String label = (String)graph.getPossibleRelatedValue(relation, L0.HasLabel);
                        if (label == null) {
                            label = "";
                        }
                        if ((description = (String)graph.getPossibleRelatedValue(relation, L0.HasDescription)) == null) {
                            description = "";
                        }
                        NumberType numberType = null;
                        if (type == null) {
                            type = "Double";
                        }
                        String unit = (String)graph.getPossibleRelatedValue(relation, L0X.HasUnit, (Binding)Bindings.STRING);
                        String defaultValue = "0";
                        String expression = null;
                        for (Resource assertion : graph.getAssertedObjects(ComponentTypeViewer.this.data.componentType, relation)) {
                            try {
                                expression = (String)graph.getPossibleRelatedValue(assertion, L0.SCLValue_expression, (Binding)Bindings.STRING);
                                if (expression != null) {
                                    defaultValue = "=" + expression;
                                    continue;
                                }
                                Datatype dt = ComponentTypeViewer.this.getPossibleDatatype(graph, assertion);
                                if (dt == null) continue;
                                if (dt instanceof NumberType) {
                                    numberType = (NumberType)dt;
                                }
                                Binding binding = Bindings.getBinding((Datatype)dt);
                                Object value = graph.getValue(assertion, binding);
                                try {
                                    defaultValue = binding.toString(value, true);
                                }
                                catch (BindingException e) {
                                    ErrorLogger.defaultLogError((Throwable)e);
                                }
                            }
                            catch (DatabaseException e) {
                                ErrorLogger.defaultLogError((Throwable)e);
                            }
                        }
                        String valid = expression != null ? DerivedPropertiesSection.validateMonitorExpression((RequestProcessor)graph, ComponentTypeViewer.this.data.componentType, relation, expression) : null;
                        boolean immutable = typeIsImmutable || graph.isImmutable(relation);
                        ComponentTypeViewerPropertyInfo info = new ComponentTypeViewerPropertyInfo(relation, name, type, defaultValue, numberType, unit, label, description, expression, valid, immutable);
                        Object sectionSpecificData = null;
                        double priority = Double.NEGATIVE_INFINITY;
                        for (ComponentTypeViewerSection section : ComponentTypeViewer.this.sections) {
                            double sectionPriority;
                            Object temp = section.getSectionSpecificData(graph, info);
                            if (temp == null || !((sectionPriority = section.getDataPriority()) > priority)) continue;
                            sectionSpecificData = temp;
                            priority = sectionPriority;
                        }
                        info.sectionSpecificData = sectionSpecificData;
                        result.add(info);
                        continue;
                    }
                    if (!graph.isInstanceOf(relation, STR.ConnectionRelation)) continue;
                    NamedResource nr = new NamedResource(NameUtils.getSafeName((ReadGraph)graph, (Resource)relation), relation);
                    connectionPoints.add(nr);
                }
                Collections.sort(result);
                return new ComponentTypePropertiesResult(result, connectionPoints, typeIsImmutable);
            }
        }, (Listener)new Listener<ComponentTypePropertiesResult>(){

            public void execute(final ComponentTypePropertiesResult result) {
                SWTUtils.asyncExec((Display)ComponentTypeViewer.this.data.form.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).ComponentTypeViewer.this.data.properties = result.getProperties().toArray(new ComponentTypeViewerPropertyInfo[result.getProperties().size()]);
                        (this).ComponentTypeViewer.this.data.connectionPoints = result.getConnectionPoints().toArray(new NamedResource[result.getConnectionPoints().size()]);
                        for (ComponentTypeViewerSection section : (this).ComponentTypeViewer.this.sections) {
                            section.update(result);
                        }
                        ComponentTypeViewer.this.setReadOnly(result.isImmutable());
                    }
                });
            }

            public void exception(Throwable t) {
                ErrorLogger.defaultLogError((Throwable)t);
            }

            public boolean isDisposed() {
                return ComponentTypeViewer.this.data.form.isDisposed();
            }
        });
    }

    protected Datatype getPossibleDatatype(ReadGraph graph, Resource literal) throws DatabaseException {
        Binding binding = Bindings.getBindingUnchecked(Datatype.class);
        for (Resource dataTypeResource : graph.getObjects(literal, Layer0.getInstance((ReadGraph)graph).HasDataType)) {
            Datatype dt = (Datatype)graph.getPossibleValue(dataTypeResource, binding);
            if (dt == null) continue;
            return dt;
        }
        return null;
    }

    public void setFocus() {
        this.data.form.setFocus();
    }

    private void setReadOnly(boolean readOnly) {
        if (readOnly == this.data.readOnly) {
            return;
        }
        this.data.readOnly = readOnly;
        for (ComponentTypeViewerSection section : this.sections) {
            section.setReadOnly(readOnly);
        }
        IMessageManager mm = this.data.form.getMessageManager();
        if (readOnly) {
            mm.addMessage((Object)"readonly", Messages.ComponentTypeViewer_OpenedInReadOnly, null, 1);
        } else {
            mm.removeMessage((Object)"readonly");
        }
    }
}

