/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.BlockingAsyncProcedure;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncReadEntry<T>
extends CacheEntryBase<AsyncProcedure<T>>
implements AsyncProcedure<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncReadEntry.class);
    protected AsyncRead<T> request;

    AsyncReadEntry(AsyncRead<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void except(AsyncReadGraph graph, Throwable t) {
        assert (this.isPending());
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.except(t);
        }
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph) {
                try {
                    BlockingAsyncProcedure proc = new BlockingAsyncProcedure(graph.asyncBarrier, graph, new AsyncProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            AsyncReadEntry.this.setResult(result);
                            AsyncReadEntry.this.setReady();
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            AsyncReadEntry.this.except(t);
                        }
                    }, AsyncReadEntry.this.request);
                    AsyncReadEntry.this.request.perform((AsyncReadGraph)graph, proc);
                    proc.get();
                }
                catch (Throwable t) {
                    AsyncReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor qp) {
                qp.cache.remove(AsyncReadEntry.this);
            }

            @Override
            public int type() {
                return AsyncReadEntry.this.request.getFlags();
            }

            public String toString() {
                if (AsyncReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                if (AsyncReadEntry.this.isExcepted()) {
                    return String.valueOf(AsyncReadEntry.this.request.toString()) + " " + AsyncReadEntry.this.getResult();
                }
                return String.valueOf(AsyncReadEntry.this.request.toString()) + " " + AsyncReadEntry.this.statusOrException;
            }
        };
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, AsyncProcedure<T> proc) {
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.exception failed", t);
            }
        } else {
            try {
                Object result = this.getResult();
                proc.execute((AsyncReadGraph)graph, result);
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.execute failed", t);
            }
        }
        return this.getResult();
    }

    public static <T> T computeForEach(ReadGraphImpl graph, AsyncRead<T> request, AsyncReadEntry<T> entry, AsyncProcedure<T> procedure_, boolean needsToBlock) throws DatabaseException {
        AsyncReadEntry<T> procedure = entry != null ? entry : procedure_;
        ReadGraphImpl queryGraph = graph.withParent(entry);
        queryGraph.asyncBarrier.inc();
        BlockingAsyncProcedure proc = new BlockingAsyncProcedure(queryGraph.asyncBarrier, graph, null, request);
        try {
            request.perform((AsyncReadGraph)queryGraph, proc);
        }
        finally {
            queryGraph.asyncBarrier.dec();
        }
        class AsyncTask
        extends QueryProcessor.SessionTask {
            int counter;
            T result;
            DatabaseException exception;
            private final /* synthetic */ boolean val$needsToBlock;
            private final /* synthetic */ BlockingAsyncProcedure val$proc;
            private final /* synthetic */ AsyncReadEntry val$entry;
            private final /* synthetic */ AsyncProcedure val$procedure_;
            private final /* synthetic */ AsyncProcedure val$procedure;
            private final /* synthetic */ ReadGraphImpl val$queryGraph;

            public AsyncTask(ReadGraphImpl graph, boolean bl, BlockingAsyncProcedure blockingAsyncProcedure, AsyncReadEntry asyncReadEntry, AsyncProcedure asyncProcedure, AsyncProcedure asyncProcedure2, ReadGraphImpl readGraphImpl) {
                this.val$needsToBlock = bl;
                this.val$proc = blockingAsyncProcedure;
                this.val$entry = asyncReadEntry;
                this.val$procedure_ = asyncProcedure;
                this.val$procedure = asyncProcedure2;
                this.val$queryGraph = readGraphImpl;
                super(graph);
                this.counter = 0;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run0(int thread) {
                if (this.val$needsToBlock) {
                    this.val$proc.waitBarrier();
                }
                if (this.val$proc.isDone()) {
                    ReadGraphImpl executeGraph = this.graph.withParent(this.graph.parent);
                    executeGraph.asyncBarrier.inc();
                    try {
                        try {
                            this.result = this.val$proc.get();
                            if (this.val$procedure == null) return;
                            this.val$procedure.execute((AsyncReadGraph)executeGraph, this.result);
                            return;
                        }
                        catch (DatabaseException e) {
                            if (this.val$procedure != null) {
                                this.val$procedure.exception((AsyncReadGraph)executeGraph, (Throwable)e);
                            }
                            this.exception = e;
                            if (this.val$entry != null) {
                                this.val$entry.performFromCache(executeGraph, this.val$procedure_);
                            }
                            executeGraph.asyncBarrier.dec();
                            executeGraph.asyncBarrier.waitBarrier(this.val$procedure, executeGraph);
                            return;
                        }
                        catch (Throwable t) {
                            block14: {
                                DatabaseException dbe = new DatabaseException(t);
                                if (this.val$procedure != null) {
                                    this.val$procedure.exception((AsyncReadGraph)executeGraph, (Throwable)dbe);
                                }
                                this.exception = dbe;
                                if (this.val$entry == null) break block14;
                                this.val$entry.performFromCache(executeGraph, this.val$procedure_);
                            }
                            executeGraph.asyncBarrier.dec();
                            executeGraph.asyncBarrier.waitBarrier(this.val$procedure, executeGraph);
                            return;
                        }
                    }
                    finally {
                        if (this.val$entry != null) {
                            this.val$entry.performFromCache(executeGraph, this.val$procedure_);
                        }
                        executeGraph.asyncBarrier.dec();
                        executeGraph.asyncBarrier.waitBarrier(this.val$procedure, executeGraph);
                    }
                }
                if (this.counter++ > 10000) {
                    throw new IllegalStateException("Eternal loop in queries.");
                }
                this.graph.processor.schedule(new AsyncTask(this.graph, this.val$needsToBlock, this.val$proc, this.val$entry, this.val$procedure_, this.val$procedure, this.val$queryGraph));
            }
        }
        AsyncTask task = new AsyncTask(graph, needsToBlock, proc, entry, procedure_, procedure, queryGraph);
        if (needsToBlock) {
            task.run(0);
        } else if (proc.isDone()) {
            task.run(0);
        } else {
            graph.processor.schedule(task);
            return null;
        }
        if (task.exception != null) {
            throw task.exception;
        }
        return task.result;
    }

    public String toString() {
        if (this.isDiscarded()) {
            return "DISCARDED " + this.request.toString();
        }
        if (this.isExcepted()) {
            return String.valueOf(this.request.toString()) + " " + this.getResult();
        }
        return String.valueOf(this.request.toString()) + " " + this.statusOrException;
    }

    public void execute(AsyncReadGraph graph, T result) {
        this.setResult(result);
        this.setReady();
    }

    public void exception(AsyncReadGraph graph, Throwable throwable) {
        this.except(throwable);
    }
}

