/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;

public class RuntimeEnvironmentRequest
extends UnaryRead<Resource, RuntimeEnvironment> {
    public RuntimeEnvironmentRequest(Resource parameter) {
        super((Object)parameter);
    }

    protected void fillEnvironmentSpecification(EnvironmentSpecification environmentSpecification) {
    }

    public static void getRuntimeEnvironment(final EnvironmentSpecification environmentSpecification, final Listener<RuntimeEnvironment> callback, final UpdateListenerImpl listener) {
        try {
            RuntimeEnvironment env;
            SCLContext context = SCLContext.getCurrent();
            Object graph = context.get((Object)"graph");
            if (graph == null) {
                try {
                    env = (RuntimeEnvironment)SimanticsInternal.getSession().syncRequest((Read)new Read<RuntimeEnvironment>(){

                        public RuntimeEnvironment perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.get((Object)"graph");
                            try {
                                sclContext.put((Object)"graph", (Object)graph);
                                RuntimeEnvironment runtimeEnvironment = SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(environmentSpecification, callback.getClass().getClassLoader(), (UpdateListener)listener);
                                return runtimeEnvironment;
                            }
                            catch (ImportFailureException e) {
                                throw new DatabaseException((Throwable)e);
                            }
                            catch (Throwable t) {
                                throw new DatabaseException(t);
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    callback.exception((Throwable)e);
                    return;
                }
            } else {
                env = SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(environmentSpecification, callback.getClass().getClassLoader(), (UpdateListener)listener);
            }
            callback.execute((Object)env);
        }
        catch (ImportFailureException e) {
            callback.exception((Throwable)new DatabaseException((Throwable)e));
        }
    }

    public RuntimeEnvironment perform(ReadGraph graph) throws DatabaseException {
        String mainModuleUri;
        final EnvironmentSpecification environmentSpecification = EnvironmentSpecification.of((String[])new String[]{"Builtin", "", "StandardLibrary", "", "Simantics/All", ""});
        this.fillEnvironmentSpecification(environmentSpecification);
        Resource mainModule = Layer0Utils.getPossibleChild(graph, (Resource)this.parameter, "SCLMain");
        if (mainModule != null) {
            mainModuleUri = graph.getURI(mainModule);
            environmentSpecification.importModule(mainModuleUri, "");
        } else {
            mainModuleUri = String.valueOf(graph.getURI((Resource)this.parameter)) + "/#";
        }
        return (RuntimeEnvironment)graph.syncRequest((ExternalRead)new ParametrizedPrimitiveRead<String, RuntimeEnvironment>(mainModuleUri){
            UpdateListenerImpl sclListener;

            public void register(ReadGraph graph, Listener<RuntimeEnvironment> procedure) {
                SCLContext context = SCLContext.getCurrent();
                Object oldGraph = context.put((Object)"graph", (Object)graph);
                try {
                    if (procedure.isDisposed()) {
                        RuntimeEnvironmentRequest.getRuntimeEnvironment(environmentSpecification, procedure, null);
                    } else {
                        this.sclListener = new UpdateListenerImpl(environmentSpecification, procedure);
                        this.sclListener.notifyAboutUpdate();
                    }
                }
                finally {
                    context.put((Object)"graph", oldGraph);
                }
            }

            public void unregistered() {
                if (this.sclListener != null) {
                    this.sclListener.stopListening();
                }
            }
        });
    }

    public int hashCode() {
        return 31 * ((Object)((Object)this)).getClass().hashCode() + super.hashCode();
    }

    static class UpdateListenerImpl
    extends UpdateListener {
        final EnvironmentSpecification environmentSpecification;
        final Listener<RuntimeEnvironment> callback;

        UpdateListenerImpl(EnvironmentSpecification environmentSpecification, Listener<RuntimeEnvironment> callback) {
            this.environmentSpecification = environmentSpecification;
            this.callback = callback;
        }

        public void notifyAboutUpdate() {
            if (this.callback.isDisposed()) {
                this.stopListening();
                return;
            }
            RuntimeEnvironmentRequest.getRuntimeEnvironment(this.environmentSpecification, this.callback, this);
        }
    }
}

