/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.IRule;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.mapping.rule.instructions.UnlessRuleInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class UnlessRule
implements IRule {
    IConstraint condition;
    IRule rule;

    public UnlessRule(IConstraint condition, IRule rule) {
        this.condition = condition;
        this.rule = rule;
    }

    @Override
    public ImmutableSet<Resource> binds() {
        return this.condition.binds().addAll(this.rule.binds());
    }

    @Override
    public IRuleInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        IInstruction conditionInstruction = this.condition.createInstruction(variableIds, bound);
        bound = bound.addAll(this.condition.binds());
        return new UnlessRuleInstruction(conditionInstruction, this.rule.createInstruction(variableIds, (ImmutableSet<Resource>)bound));
    }
}

