/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.modelBrowser.contributions;

import java.util.Map;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.graph.impl.LabelerUtil;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.ArrayMap;

public enum ExperimentLabelRule implements LabelRule
{
    INSTANCE;


    public static ExperimentLabelRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Resource experiment = (Resource)content;
        String name = LabelerUtil.safeStringRepresentation((ReadGraph)graph, (Resource)experiment);
        Resource initialState = graph.getPossibleObject(experiment, SimulationResource.getInstance((ReadGraph)graph).HasInitialState);
        if (initialState != null) {
            name = String.valueOf(name) + " (" + LabelerUtil.safeStringRepresentation((ReadGraph)graph, (Resource)initialState) + ")";
        }
        return ArrayMap.make((Object[])ColumnKeys.KEYS_SINGLE, (Object[])new String[]{name});
    }
}

