/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.client;

import java.util.HashSet;
import java.util.TreeMap;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.AlphanumericComparator;
import org.simantics.document.server.client.CommandManager;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.WidgetManager;

public class WidgetData {
    public Object widget;
    public JSONObject object;
    public Document document;
    public TreeMap<String, WidgetData> childmap = new TreeMap(new AlphanumericComparator());
    public HashSet<Object> listenerRegistrations = new HashSet();

    public WidgetData(Document document, Object widget, JSONObject object) {
        this.widget = widget;
        this.object = object;
        this.document = document;
    }

    public Object createElement() {
        if (this.object == null) {
            return null;
        }
        WidgetManager<?, ?> manager = this.document.getManager(this.object);
        return manager == null ? null : manager.createWidget(this.object);
    }

    public void updateChildren() {
        WidgetManager<?, ?> manager;
        if (this.object != null && this.widget != null && this.childmap != null && (manager = this.document.getManager(this.object)) != null) {
            manager.updateChildren(this.document, this.object, this.widget, this.childmap);
        }
    }

    public void updateProperties() {
        if (this.object == null) {
            return;
        }
        WidgetManager<?, ?> manager = this.document.getManager(this.object);
        if (manager != null) {
            manager.updateProperties(this.document, this.object, this.widget);
        }
    }

    public void updateCommands() {
        if (this.object == null) {
            return;
        }
        CommandManager<?, ?> manager = this.document.getCommandManager(this.object);
        if (manager != null) {
            for (Object listener : this.listenerRegistrations) {
                manager.removeListener(this.widget, listener);
            }
        }
        this.listenerRegistrations.clear();
        if (manager != null) {
            this.listenerRegistrations.addAll(manager.updateCommandListeners(this.document, this.object, this.widget));
        }
    }

    public IEventCommand eventCommand(String command) {
        if (this.object == null) {
            return null;
        }
        WidgetManager<?, ?> manager = this.document.getManager(this.object);
        if (manager != null) {
            return manager.eventCommand(this.document, this.object, this.widget, command);
        }
        return null;
    }
}

