/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.outline;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;
import org.simantics.scl.ui.editor2.SCLModuleEditorInput;

public class SCLModuleOutlinePage
extends ContentOutlinePage {
    private TreeViewer outlineViewer;
    private SCLModuleEditor2 moduleEditor;
    private UpdateListener updateListener;
    private LocalResourceManager resourceManager;
    private Image publicImage;
    private Image privateImage;
    private Image typeImage;

    public SCLModuleOutlinePage(SCLModuleEditor2 moduleEditor) {
        this.moduleEditor = moduleEditor;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.publicImage = this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/public_co.gif"));
        this.privateImage = this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/private_co.gif"));
        this.typeImage = this.resourceManager.createImage(Activator.imageDescriptorFromPlugin((String)"org.simantics.scl.ui", (String)"icons/typedef_obj.gif"));
    }

    public void createControl(final Composite parent) {
        super.createControl(parent);
        this.outlineViewer = this.getTreeViewer();
        SCLModuleOutlineProvider provider = new SCLModuleOutlineProvider();
        DelegatingStyledCellLabelProvider labelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)provider);
        this.outlineViewer.setContentProvider((IContentProvider)provider);
        this.outlineViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.outlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        SCLModuleEditorInput input = (SCLModuleEditorInput)this.moduleEditor.getEditorInput();
        ModuleSource moduleSource = (ModuleSource)input.getAdapter(ModuleSource.class);
        this.updateListener = new UpdateListener(){

            public void notifyAboutUpdate() {
                parent.getDisplay().asyncExec(() -> {
                    if (!SCLModuleOutlinePage.this.outlineViewer.getControl().isDisposed()) {
                        SCLModuleOutlinePage.this.outlineViewer.refresh();
                    }
                });
            }
        };
        Failable module = SCLOsgi.MODULE_REPOSITORY.getModule(moduleSource.getModuleName(), this.updateListener);
        Module result = (Module)module.getResult();
        this.outlineViewer.setInput((Object)result);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        TreeSelection tselection = (TreeSelection)selection;
        if (tselection.getFirstElement() instanceof SCLValue) {
            SCLValue value = (SCLValue)tselection.getFirstElement();
            long location = value.definitionLocation;
            int begin = Locations.beginOf((long)location);
            int end = Locations.endOf((long)location);
            this.moduleEditor.selectAndReveal(begin, end - begin);
        }
    }

    public void dispose() {
        this.resourceManager.dispose();
        super.dispose();
    }

    protected class SCLModuleOutlineProvider
    implements ITreeContentProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        protected SCLModuleOutlineProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Module result = (Module)inputElement;
            ArrayList<SCLValue> values = new ArrayList<SCLValue>();
            result.findValuesForPrefix("", (NamespaceFilter)AcceptAllNamespaceFilter.INSTANCE, value -> values.add((SCLValue)value));
            values.sort(new Comparator<SCLValue>(){

                @Override
                public int compare(SCLValue o1, SCLValue o2) {
                    int isPrivate = Boolean.compare(o1.isPrivate(), o2.isPrivate());
                    if (isPrivate != 0) {
                        return isPrivate;
                    }
                    return o1.getName().name.compareTo(o2.getName().name);
                }
            });
            ArrayList<TCon> types = new ArrayList<TCon>();
            result.findTypesForPrefix("", (NamespaceFilter)AcceptAllNamespaceFilter.INSTANCE, type -> types.add((TCon)type));
            types.sort(new Comparator<TCon>(){

                @Override
                public int compare(TCon o1, TCon o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            ArrayList<Object> results = new ArrayList<Object>();
            results.addAll(types);
            results.addAll(values);
            return results.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof SCLValue) {
                SCLValue value = (SCLValue)element;
                if (value.isPrivate()) {
                    return SCLModuleOutlinePage.this.privateImage;
                }
                return SCLModuleOutlinePage.this.publicImage;
            }
            if (element instanceof TCon) {
                return SCLModuleOutlinePage.this.typeImage;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof SCLValue) {
                SCLValue value = (SCLValue)element;
                StyledString ss = new StyledString(value.getName().name);
                ss.append(" :: " + value.getType().toString(), StyledString.COUNTER_STYLER);
                return ss;
            }
            TCon type = (TCon)element;
            return new StyledString(type.name);
        }
    }
}

