/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.source.repository;

import gnu.trove.procedure.TObjectProcedure;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.compiler.source.TextualModuleSource;

public interface ModuleSourceRepository {
    public Collection<String> getModuleNames();

    default public void forAllModules(TObjectProcedure<String> procedure) {
        for (String module : this.getModuleNames()) {
            if (procedure.execute((Object)module)) continue;
            return;
        }
    }

    public ModuleSource getModuleSource(String var1, UpdateListener var2);

    default public Collection<String> getDocumentationNames() {
        return Collections.emptyList();
    }

    default public void forAllDocumentations(TObjectProcedure<String> procedure) {
        for (String module : this.getDocumentationNames()) {
            if (procedure.execute((Object)module)) continue;
            return;
        }
    }

    default public String getDocumentation(String documentationName) {
        return null;
    }

    default public void checkUpdates() {
    }

    default public void clear() {
    }

    default public String getPossibleSourceText(String moduleName) throws IOException {
        ModuleSource moduleSource = this.getModuleSource(moduleName, null);
        if (moduleSource == null) {
            return null;
        }
        if (!(moduleSource instanceof TextualModuleSource)) {
            return null;
        }
        return ((TextualModuleSource)moduleSource).getSourceText(null);
    }
}

