/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.LocalVariableConstant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.continuations.ReturnCont;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PreparationStep;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class MethodBuilder
extends MethodBuilderBase {
    ModuleBuilder moduleBuilder;
    THashMap<Cont, Label> labels = new THashMap();
    THashMap<BoundVar, LocalVariable> localVariables = new THashMap();
    THashSet<Cont> generatedConts = new THashSet();
    THashMap<Object, Object> preparationSteps = new THashMap(4);

    public MethodBuilder(ClassBuilder classBuilder, ModuleBuilder moduleBuilder, boolean isStatic, MethodVisitor methodVisitor, TypeDesc[] parameterTypes) {
        super(classBuilder, isStatic, methodVisitor, parameterTypes);
        this.moduleBuilder = moduleBuilder;
    }

    public JavaTypeTranslator getJavaTypeTranslator() {
        return this.getModuleBuilder().getJavaTypeTranslator();
    }

    public ModuleBuilder getModuleBuilder() {
        return this.moduleBuilder;
    }

    public void push(IVal val, Type type) {
        val.push(this);
        if (Types.canonical(type) instanceof TVar) {
            this.box(val.getType());
        }
    }

    public void push(Val[] vals, Type[] types) {
        assert (vals.length == types.length);
        int i = 0;
        while (i < vals.length) {
            this.push(vals[i], types[i]);
            ++i;
        }
    }

    public void pushBoxed(Val val) {
        val.push(this);
        this.box(val.getType());
    }

    public void pushBoxed(Val[] vals) {
        Val[] valArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Val val = valArray[n2];
            this.pushBoxed(val);
            ++n2;
        }
    }

    public void genericApply(int arity) {
        this.invokeInterface(Constants.FUNCTION, "apply", TypeDesc.OBJECT, Constants.OBJECTS[arity]);
    }

    public void pushTuple0() {
        this.loadStaticField(Constants.TUPLE0, "INSTANCE", Constants.TUPLE0);
    }

    private void boxPrimitiveType(TypeDesc primitiveType) {
        if (primitiveType.equals(TypeDesc.VOID)) {
            this.pushTuple0();
        } else {
            TypeDesc objectType = primitiveType.toObjectType();
            this.invokeStatic(MethodBuilder.getClassName(objectType), "valueOf", objectType, new TypeDesc[]{primitiveType});
        }
    }

    public void box(Type type) {
        TypeDesc typeDesc = this.getJavaTypeTranslator().toTypeDesc(type);
        if (typeDesc.isPrimitive()) {
            this.boxPrimitiveType(typeDesc);
        }
    }

    public void unbox(Type type) {
        TypeDesc td = this.getJavaTypeTranslator().toTypeDesc(type);
        if (td.equals(TypeDesc.VOID)) {
            this.pop();
            return;
        }
        if (td.isPrimitive()) {
            TypeDesc objectType = td.toObjectType();
            this.checkCast(objectType);
            this.convert(objectType, td);
        } else if (td != TypeDesc.OBJECT) {
            this.checkCast(td);
        }
    }

    public void setLocation(Cont continuation) {
        this.setLocation(this.getLabel(continuation));
        if (!this.generatedConts.add((Object)continuation)) {
            throw new InternalCompilerError("Label location is set multiple times");
        }
    }

    public Label getLabel(Cont continuation) {
        Label label = (Label)this.labels.get((Object)continuation);
        if (label == null) {
            label = this.createLabel();
            this.labels.put((Object)continuation, (Object)label);
        }
        return label;
    }

    public void setLocalVariable(BoundVar var, LocalVariable localVariable) {
        this.localVariables.put((Object)var, (Object)localVariable);
    }

    public LocalVariable getLocalVariable(BoundVar var) {
        LocalVariable localVariable = (LocalVariable)this.localVariables.get((Object)var);
        if (localVariable == null) {
            TypeDesc typeDesc = this.getJavaTypeTranslator().getTypeDesc(var);
            localVariable = this.createLocalVariable(null, typeDesc);
            this.localVariables.put((Object)var, (Object)localVariable);
        }
        return localVariable;
    }

    public void jump(ContRef target) {
        this.jump(target.getBinding());
    }

    public void jump(ContRef target, Val ... parameters) {
        this.jump(target.getBinding(), (IVal[])parameters);
    }

    public void jump(Cont cont) {
        if (cont instanceof SSABlock) {
            SSABlock block = (SSABlock)cont;
            if (this.generatedConts.contains((Object)block)) {
                this.branch(this.getLabel(block));
            } else {
                block.generateCode(this);
            }
        } else {
            throw new InternalCompilerError();
        }
    }

    public void jump(Cont cont, IVal ... parameters) {
        if (cont instanceof ReturnCont) {
            ReturnCont returnCont = (ReturnCont)cont;
            if (parameters.length != 1) {
                throw new InternalCompilerError();
            }
            this.push(parameters[0], returnCont.getType());
            this.returnValue(this.getJavaTypeTranslator().toTypeDesc(returnCont.getType()));
        } else if (cont instanceof SSABlock) {
            SSABlock block = (SSABlock)cont;
            BoundVar[] parameterVars = block.getParameters();
            if (parameters.length != parameterVars.length) {
                throw new InternalCompilerError();
            }
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i] != parameterVars[i]) {
                    this.push(parameters[i], parameterVars[i].getType());
                }
                ++i;
            }
            i = parameters.length - 1;
            while (i >= 0) {
                if (parameters[i] != parameterVars[i]) {
                    this.store(parameterVars[i]);
                }
                --i;
            }
            if (this.generatedConts.contains((Object)block)) {
                this.branch(this.getLabel(block));
            } else {
                block.generateCode(this);
            }
        } else {
            throw new InternalCompilerError();
        }
    }

    public void store(BoundVar var) {
        Type type = var.getType();
        TypeDesc typeDesc = this.getJavaTypeTranslator().toTypeDesc(type);
        if (typeDesc.equals(TypeDesc.VOID)) {
            return;
        }
        LocalVariable lv = this.getLocalVariable(var);
        this.storeLocal(lv);
    }

    public void ensureExists(Cont continuation) {
        if (!this.generatedConts.contains((Object)continuation)) {
            ((SSABlock)continuation).generateCode(this);
        }
    }

    public <T> T getPreparation(PreparationStep<T> step) {
        return (T)this.preparationSteps.get(step);
    }

    public <T> void addPreparation(PreparationStep<T> step, T result) {
        this.preparationSteps.put(step, result);
    }

    public LocalVariable cacheValue(IVal val, Type type) {
        if (val instanceof BoundVar) {
            BoundVar boundVar = (BoundVar)val;
            if (!boundVar.generateOnFly) {
                return this.getLocalVariable(boundVar);
            }
        } else if (val instanceof LocalVariableConstant) {
            return ((LocalVariableConstant)val).var;
        }
        this.push(val, type);
        LocalVariable temp = this.createLocalVariable(null, this.getJavaTypeTranslator().toTypeDesc(type));
        this.storeLocal(temp);
        return temp;
    }
}

