/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Case;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EIf;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EMatch;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationMode;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class QueryCompilationContext {
    TypingContext context;
    QueryCompilationMode mode;
    Type resultType;
    Expression continuation;
    double branching = 1.0;
    double cost = 0.0;

    public QueryCompilationContext(TypingContext context, QueryCompilationMode mode, Type resultType, Expression continuation) {
        this.context = context;
        this.mode = mode;
        this.resultType = resultType;
        this.continuation = continuation;
    }

    public Expression failure() {
        switch (this.mode) {
            case ITERATE: {
                return new EConstant(Builtins.TUPLE_CONSTRUCTORS[0]);
            }
            case GET_FIRST: {
                return new EConstant(Builtins.Nothing, this.resultType);
            }
            case GET_ALL: {
                return new EConstant(Builtins.LIST_CONSTRUCTORS[0], this.resultType);
            }
            case CHECK: {
                return new ELiteral(new BooleanConstant(false));
            }
        }
        throw new InternalCompilerError();
    }

    public Expression disjunction(Expression a, Expression b) {
        switch (this.mode) {
            case ITERATE: {
                return new ESimpleLet(new Variable("_", Types.UNIT), a, b);
            }
            case GET_FIRST: {
                Variable var = new Variable("temp", a.getType());
                return new EMatch(a, new Case(new EConstant(Builtins.Nothing), b), new Case(new EVariable(var), (Expression)new EVariable(var)));
            }
            case GET_ALL: {
                try {
                    return new EApply(this.context.getCompilationContext().getConstant(Names.Prelude_appendList, Types.matchApply(Types.LIST, a.getType())), a, b);
                }
                catch (MatchException matchException) {
                    throw new InternalCompilerError();
                }
            }
            case CHECK: {
                return new EIf(a, new ELiteral(new BooleanConstant(true)), b);
            }
        }
        throw new InternalCompilerError();
    }

    public Expression condition(Expression condition, Expression continuation) {
        return new EIf(condition, continuation, this.failure());
    }

    public void condition(Expression condition) {
        this.continuation = this.condition(condition, this.continuation);
    }

    public void equalityCondition(long location, Expression a, Expression b) {
        Type type = a.getType();
        this.condition(new EApply(location, Types.PROC, this.context.getCompilationContext().getConstant(Names.Builtin_equals, type), a, b));
    }

    public void let(Variable variable, Expression value) {
        this.continuation = new ESimpleLet(variable, value, this.continuation);
    }

    public void iterateMaybe(Variable variable, Expression value) {
        this.continuation = new EMatch(value, new Case(Expressions.Nothing(variable.getType()), this.failure()), new Case(Expressions.Just(Expressions.var(variable)), this.continuation));
    }

    public void match(Expression pattern, Expression value, boolean mayFail) {
        this.continuation = mayFail ? new EMatch(value, new Case(pattern, this.continuation), new Case(new EVariable(new Variable("_", pattern.getType())), this.failure())) : new EMatch(value, new Case(pattern, this.continuation));
    }

    public void iterateList(Variable variable, Expression list) {
        try {
            switch (this.mode) {
                case ITERATE: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Prelude_iterList, variable.getType(), Types.PROC, Types.tupleConstructor(0)), new ESimpleLambda(Types.PROC, variable, this.continuation), list);
                    break;
                }
                case CHECK: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Prelude_any, variable.getType(), Types.PROC), new ESimpleLambda(Types.PROC, variable, this.continuation), list);
                    break;
                }
                case GET_ALL: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Prelude_concatMap, variable.getType(), Types.PROC, Types.matchApply(Types.LIST, this.continuation.getType())), new ESimpleLambda(Types.PROC, variable, this.continuation), list);
                    break;
                }
                case GET_FIRST: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Prelude_mapFirst, variable.getType(), Types.PROC, Types.matchApply(Types.MAYBE, this.continuation.getType())), new ESimpleLambda(Types.PROC, variable, this.continuation), list);
                    break;
                }
                default: {
                    throw new InternalCompilerError("iterateList could not handle mode " + (Object)((Object)this.mode));
                }
            }
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public void iterateVector(Variable variable, Expression vector) {
        try {
            switch (this.mode) {
                case ITERATE: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Vector_iterVector, variable.getType(), Types.PROC, this.continuation.getType()), new ESimpleLambda(Types.PROC, variable, this.continuation), vector);
                    break;
                }
                case CHECK: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Vector_anyVector, variable.getType(), Types.PROC), new ESimpleLambda(Types.PROC, variable, this.continuation), vector);
                    break;
                }
                case GET_ALL: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Vector_concatMapVector, variable.getType(), Types.PROC, Types.matchApply(Types.LIST, this.continuation.getType())), new ESimpleLambda(Types.PROC, variable, this.continuation), vector);
                    break;
                }
                case GET_FIRST: {
                    this.continuation = new EApply(9223372034707292160L, Types.PROC, this.context.getCompilationContext().getConstant(Names.Vector_mapFirstVector, variable.getType(), Types.PROC, Types.matchApply(Types.MAYBE, this.continuation.getType())), new ESimpleLambda(Types.PROC, variable, this.continuation), vector);
                    break;
                }
                default: {
                    throw new InternalCompilerError("iterateVector could not handle mode " + (Object)((Object)this.mode));
                }
            }
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public void iterateMSet(Variable variable, Expression set) {
        try {
            switch (this.mode) {
                case ITERATE: {
                    this.continuation = Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.MSet_iter, variable.getType(), (Type)Types.PROC, this.continuation.getType(), Expressions.lambda((Type)Types.PROC, variable, this.continuation), set);
                    break;
                }
                case GET_FIRST: {
                    this.continuation = Expressions.apply((EnvironmentalContext)this.context.getCompilationContext(), (Type)Types.PROC, Names.MSet_mapFirst, variable.getType(), (Type)Types.PROC, Types.matchApply(Types.MAYBE, this.continuation.getType()), Expressions.lambda((Type)Types.PROC, variable, this.continuation), set);
                    break;
                }
                default: {
                    throw new InternalCompilerError("iterateMSet could not handle mode " + (Object)((Object)this.mode));
                }
            }
        }
        catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }

    public void updateCost(double localBranching, double localCost) {
        this.branching *= localBranching;
        this.cost *= localBranching;
        this.cost += localCost;
    }

    public Expression getConstant(Name name, Type[] typeParameters) {
        return this.context.getCompilationContext().getConstant(name, typeParameters);
    }

    public QueryCompilationContext createCheckContext() {
        return new QueryCompilationContext(this.context, QueryCompilationMode.CHECK, null, new ELiteral(new BooleanConstant(true)));
    }

    public double getBranching() {
        return this.branching;
    }

    public double getCost() {
        return this.cost;
    }

    public QueryCompilationContext createSubcontext(Expression innerExpression) {
        return new QueryCompilationContext(this.context, this.mode, this.resultType, innerExpression);
    }

    public void setContinuation(Expression continuation) {
        this.continuation = continuation;
    }

    public Expression getContinuation() {
        return this.continuation;
    }

    public Expression disjunction(Expression[] disjuncts) {
        Expression result = this.failure();
        int i = disjuncts.length - 1;
        while (i >= 0) {
            result = this.disjunction(disjuncts[i], result);
            --i;
        }
        return result;
    }

    public TypingContext getTypingContext() {
        return this.context;
    }

    public EVariable getEvidence(long location, TPred pred) {
        EVariable evidence = new EVariable(location, null);
        evidence.setType(pred);
        this.context.addConstraintDemand(evidence);
        return evidence;
    }

    public CompilationContext getCompilationContext() {
        return this.context.getCompilationContext();
    }
}

