/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class ShortConstant
extends Constant {
    public static final ShortConstant ZERO = new ShortConstant(0);
    public static final ShortConstant ONE = new ShortConstant(1);
    public static final ShortConstant MINUS_ONE = new ShortConstant(-1);
    short value;

    public ShortConstant(short value) {
        super(Types.SHORT);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public short getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShortConstant other = (ShortConstant)obj;
        return this.value == other.value;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        mb.push(parameter, Types.SHORT);
        mb.loadConstant(this.value);
        mb.ifComparisonBranch(failure, "!=", TypeDesc.SHORT);
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

