/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.impl;

import java.util.Collection;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.AbstractDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class Diagram
extends AbstractDiagram
implements IDiagram {
    public static final IDiagram EMPTY_DIAGRAM = Diagram.spawnNew(DiagramClass.DEFAULT);

    public static IDiagram spawnNew(DiagramClass clazz) {
        Diagram d = new Diagram(clazz);
        AbstractDiagram.fireCreated(d);
        return d;
    }

    static Diagram instantiate(DiagramClass clazz) {
        Diagram d = new Diagram(clazz);
        AbstractDiagram.fireCreated(d);
        return d;
    }

    public static IDiagram clone(IDiagram src) {
        DiagramClass clazz = src.getDiagramClass();
        Diagram d = new Diagram(clazz);
        d.setHints(src.getHints());
        for (IElement e : src.getElements()) {
            d.addElement(Element.clone(e));
        }
        AbstractDiagram.fireLoaded(d);
        return d;
    }

    public static IDiagram clone(IDiagram src, Collection<IElement> elements) {
        DiagramClass clazz = src.getDiagramClass();
        Diagram d = new Diagram(clazz);
        d.setHints(src.getHints());
        for (IElement e : elements) {
            d.addElement(Element.clone(e));
        }
        AbstractDiagram.fireLoaded(d);
        return d;
    }

    Diagram(DiagramClass clazz) {
        super(clazz, (IHintContext)new HintContext());
    }

    public String toString() {
        String name = (String)this.getHint(DiagramHints.KEY_TEXT);
        if (name == null) {
            name = super.toString();
        }
        return name;
    }
}

