/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.g2d.connection.EndKeyOf;
import org.simantics.g2d.connection.TerminalKeyOf;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.ElementListener;
import org.simantics.g2d.diagram.handler.SubstituteElement;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TopologyImpl
implements Topology,
ElementListener {
    @Override
    public Topology.Connection getConnection(IElement edge, EdgeVisuals.EdgeEnd end) {
        EndKeyOf key = EndKeyOf.get(end);
        Topology.Connection c = (Topology.Connection)edge.getHint((IHintContext.Key)key);
        if (c == null) {
            return null;
        }
        IDiagram d = ElementUtils.getDiagram(edge);
        c = this._updateReferences(d, c);
        return c;
    }

    @Override
    public void getConnections(IElement node, Topology.Terminal terminal, Collection<Topology.Connection> connections) {
        TerminalKeyOf key = new TerminalKeyOf(terminal, null, Topology.Connection.class);
        Topology.Connection c = (Topology.Connection)node.getHint((IHintContext.Key)key);
        if (c != null) {
            connections.add(c);
        }
        IDiagram d = ElementUtils.getDiagram(node);
        this._updateReferences(d, c);
    }

    private Topology.Connection _updateReferences(IDiagram d, Topology.Connection c) {
        List<SubstituteElement> list = d.getDiagramClass().getItemsByClass(SubstituteElement.class);
        if (list.size() == 0) {
            return c;
        }
        IElement e = c.edge;
        IElement n = c.node;
        for (SubstituteElement se : list) {
            IElement ne = se.substitute(d, e);
            IElement nn = se.substitute(d, n);
            if (ne != null) {
                e = ne;
            }
            if (nn == null) continue;
            n = nn;
        }
        return new Topology.Connection(e, c.end, n, c.terminal);
    }

    @Override
    public void connect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
        if (edge == null) {
            throw new NullPointerException("null edge");
        }
        if (end == null) {
            throw new NullPointerException("null end");
        }
        if (node == null) {
            throw new NullPointerException("null node");
        }
        if (terminal == null) {
            throw new NullPointerException("null terminal");
        }
        IDiagram d = ElementUtils.getDiagram(edge);
        assert (d == ElementUtils.getDiagram(node));
        Topology.Connection c = new Topology.Connection(edge, end, node, terminal);
        Object edgeData = edge.getHint(ElementHints.KEY_OBJECT);
        TerminalKeyOf key = new TerminalKeyOf(terminal, edgeData, Topology.Connection.class);
        node.setHint((IHintContext.Key)key, c);
        EndKeyOf key2 = EndKeyOf.get(end);
        edge.setHint((IHintContext.Key)key2, c);
    }

    @Override
    public void disconnect(IElement edge, EdgeVisuals.EdgeEnd end, IElement node, Topology.Terminal terminal) {
        if (edge == null) {
            throw new NullPointerException("null edge");
        }
        if (end == null) {
            throw new NullPointerException("null end");
        }
        if (node == null) {
            throw new NullPointerException("null node");
        }
        if (terminal == null) {
            throw new NullPointerException("null terminal");
        }
        IDiagram d = ElementUtils.getDiagram(edge);
        assert (d == ElementUtils.getDiagram(node));
        EndKeyOf edgeKey = EndKeyOf.get(end);
        Topology.Connection c = (Topology.Connection)edge.getHint((IHintContext.Key)edgeKey);
        if (c == null) {
            throw new UnsupportedOperationException("cannot disconnect, no Connection in edge " + edge);
        }
        for (Map.Entry entry : node.getHintsOfClass(TerminalKeyOf.class).entrySet()) {
            Topology.Connection cc = (Topology.Connection)entry.getValue();
            if (c != cc) continue;
            node.removeHint((IHintContext.Key)entry.getKey());
            edge.removeHint((IHintContext.Key)edgeKey);
            return;
        }
        throw new UnsupportedOperationException("cannot disconnect, no connection between found between edge " + edge + " and node " + node);
    }

    @Override
    public void onElementAdded(IDiagram d, IElement e) {
    }

    @Override
    public void onElementRemoved(IDiagram d, IElement e) {
        Set keys1 = e.getHintsOfClass(TerminalKeyOf.class).keySet();
        for (IHintContext.KeyOf key : keys1) {
            e.removeHint((IHintContext.Key)key);
        }
        EndKeyOf[] endKeyOfArray = EndKeyOf.KEYS;
        int n = EndKeyOf.KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            IHintContext.KeyOf key;
            key = endKeyOfArray[n2];
            e.removeHint((IHintContext.Key)key);
            ++n2;
        }
    }
}

