/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.content.Labeler;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.NumberType;
import org.simantics.databoard.units.IUnitConverter;
import org.simantics.databoard.util.Range;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.PrimitiveValueParser;
import org.simantics.db.layer0.variable.InputValidator;
import org.simantics.db.layer0.variable.InputValidatorFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableWrite;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.ui.ErrorLogger;

public class VariableModifier
implements Labeler.Modifier {
    protected final Session session;
    protected final UndoContext undoContext;
    protected final Variable variable;
    protected final String targetUnit;
    private String initialValue;
    protected Throwable modifierFailed;
    private Datatype datatype;
    protected Binding binding;
    protected InputValidator variableInputValidator;

    public VariableModifier(RequestProcessor processor, Variable variable) {
        this(processor, variable, null);
    }

    public VariableModifier(RequestProcessor processor, Variable variable, String targetUnit) {
        this.variable = variable;
        this.session = processor.getSession();
        this.undoContext = null;
        this.targetUnit = targetUnit;
        this.initializeModifier(processor);
    }

    public VariableModifier(RequestProcessor processor, UndoContext undoContext, Variable variable, String targetUnit) {
        this.variable = variable;
        this.undoContext = undoContext;
        this.session = processor.getSession();
        this.targetUnit = targetUnit;
        this.initializeModifier(processor);
    }

    protected void initializeModifier(RequestProcessor processor) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    String expression = (String)VariableModifier.this.variable.getPossiblePropertyValue(graph, "HasExpression");
                    if (expression == null) {
                        VariableModifier.this.datatype = VariableModifier.this.variable.getPossibleDatatype(graph);
                        if (VariableModifier.this.datatype == null) {
                            VariableModifier.this.datatype = (Datatype)VariableModifier.this.variable.getInterface(graph, Datatype.class);
                            if (VariableModifier.this.datatype == null) {
                                throw new BindingException("no datatype for variable " + VariableModifier.this.variable, null);
                            }
                        }
                        VariableModifier.this.initialValue = VariableModifier.this.getInitialValue(graph, VariableModifier.this.datatype);
                        VariableModifier.this.binding = Bindings.getBinding((Datatype)VariableModifier.this.datatype);
                        VariableModifier.this.initializeValidator(graph, VariableModifier.this.variable);
                    } else {
                        VariableModifier.this.initialValue = "= " + expression;
                        VariableModifier.this.binding = Bindings.STRING;
                        VariableModifier.this.datatype = (Datatype)Datatypes.STRING;
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((String)"Modifier initialization failed, see exception for details.", (Throwable)e);
            this.modifierFailed = e;
        }
    }

    protected void initializeValidator(ReadGraph graph, Variable var) throws DatabaseException {
        Resource parentResource;
        Variable parent;
        Function1 validator;
        Resource resource = var.getPossibleRepresents(graph);
        Resource pr = this.variable.getPossiblePredicateResource(graph);
        if (pr != null) {
            this.variableInputValidator = this.tryInputValidatorFactory(graph, var, resource, pr);
        }
        if (this.variableInputValidator == null && (validator = (Function1)this.variable.getPossiblePropertyValue(graph, "HasInputValidator")) != null) {
            this.variableInputValidator = new InputValidator(){

                public String isValid(Object newValue) {
                    return (String)validator.apply((Object)((String)newValue));
                }
            };
        }
        if (this.variableInputValidator == null && (parent = this.variable.getParent(graph)) != null && (parentResource = parent.getPossibleRepresents(graph)) != null) {
            this.variableInputValidator = this.tryInputValidatorFactory(graph, var, resource, parentResource);
        }
        if (this.variableInputValidator == null) {
            this.variableInputValidator = (InputValidator)var.getInterface(graph, InputValidator.class);
        }
    }

    private InputValidator tryInputValidatorFactory(ReadGraph graph, Variable var, Resource varRepresents, Resource r) throws DatabaseException {
        InputValidatorFactory validatorFactory = (InputValidatorFactory)graph.getPossibleAdapter(r, InputValidatorFactory.class);
        if (validatorFactory == null) {
            return null;
        }
        return validatorFactory.create(graph, var);
    }

    protected void doModify(final String label) {
        if (label.startsWith("=")) {
            this.session.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    VariableModifier.this.variable.setPropertyValue(graph, "HasExpression", (Object)label.substring(1).trim());
                }
            });
        } else {
            if (this.initialValue.startsWith("=")) {
                try {
                    this.session.syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            VariableModifier.this.variable.setPropertyValue(graph, "HasExpression", null);
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
            this.session.asyncRequest((Write)new VariableWrite(this.variable, label, null, this.targetUnit), parameter -> {
                if (parameter != null) {
                    ErrorLogger.defaultLogError((Throwable)parameter);
                } else {
                    this.modifySuccessful();
                }
            });
        }
    }

    protected void modifySuccessful() {
    }

    protected String getInitialValue(ReadGraph graph, Datatype dataType) throws DatabaseException {
        Object value = this.variable.getPossibleValue(graph);
        if (value == null) {
            return "";
        }
        String unit = Variables.getPossibleUnit((ReadGraph)graph, (Variable)this.variable);
        if (value instanceof Double && unit != null && this.targetUnit != null) {
            IUnitConverter converter = VariableWrite.converter((String)unit, (String)this.targetUnit);
            value = converter.convert(((Double)value).doubleValue());
        }
        return FormattingUtils.US.engineeringFormat(value);
    }

    public String getValue() {
        return this.initialValue;
    }

    public String isValid(String label) {
        if (label.startsWith("=")) {
            return null;
        }
        if (this.modifierFailed != null) {
            return "Could not resolve validator for this value, modification denied. Reason: " + this.modifierFailed.getMessage();
        }
        if (this.variableInputValidator != null) {
            return this.variableInputValidator.isValid((Object)label);
        }
        try {
            if (this.binding instanceof StringBinding) {
                if (this.binding instanceof MutableStringBinding) {
                    this.binding.assertInstaceIsValid((Object)new MutableString(label));
                } else {
                    this.binding.assertInstaceIsValid((Object)label);
                }
            } else if (this.binding instanceof NumberBinding) {
                label = label.replace(",", ".");
                Object value = PrimitiveValueParser.parse((String)label, (Datatype)this.datatype);
                NumberType numberType = (NumberType)this.datatype;
                Range range = numberType.getRange();
                if (range != null && !range.contains((Number)value)) {
                    return "Value is not in range " + range;
                }
            } else {
                this.binding.parseValue(label, new DataValueRepository());
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return e.getLocalizedMessage();
        }
        catch (DataTypeSyntaxError e) {
            return e.getLocalizedMessage();
        }
        catch (org.simantics.databoard.binding.error.BindingException e) {
            return e.getLocalizedMessage();
        }
    }

    public final void modify(String label) {
        if (this.modifierFailed != null) {
            throw new Error("modifier failed: " + this.modifierFailed.getMessage());
        }
        this.doModify(label);
    }
}

