/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.graph.impl.URIResourceInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSelectionInputSource;
import org.simantics.db.Resource;
import org.simantics.db.management.ISessionContext;

public class GraphInputSources {
    public static SessionContextInputSource uriSource(String uri) {
        return new URIResourceInputSource(uri);
    }

    public static SessionContextInputSource projectSource() {
        return new SessionContextInputSource(){

            @Override
            public Object get(ISessionContext ctx) {
                Resource project = Simantics.peekProjectResource();
                return project != null ? project : GraphExplorer.EMPTY_INPUT;
            }

            @Override
            public IWorkbenchPart getProvider() {
                return null;
            }
        };
    }

    public static SessionContextInputSource constant(final Object input) {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        return new SessionContextInputSource(){

            @Override
            public Object get(ISessionContext ctx) {
                return input;
            }

            @Override
            public IWorkbenchPart getProvider() {
                return null;
            }
        };
    }

    public static SessionContextInputSource workbenchSelection() {
        return new WorkbenchSelectionInputSource();
    }
}

