/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.uninverting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.uninverting.FieldCache;
import org.apache.lucene.util.Bits;

@Deprecated
public class UninvertingReader
extends FilterLeafReader {
    final Map<String, Type> mapping;
    final FieldInfos fieldInfos;

    public static DirectoryReader wrap(DirectoryReader in, Map<String, Type> mapping) throws IOException {
        return new UninvertingDirectoryReader(in, mapping);
    }

    public UninvertingReader(LeafReader in, Map<String, Type> mapping) {
        super(in);
        this.mapping = mapping;
        ArrayList<FieldInfo> filteredInfos = new ArrayList<FieldInfo>();
        for (FieldInfo fi : in.getFieldInfos()) {
            Type t;
            DocValuesType type = fi.getDocValuesType();
            if (type == DocValuesType.NONE && (t = mapping.get(fi.name)) != null) {
                if (t == Type.INTEGER_POINT || t == Type.LONG_POINT || t == Type.FLOAT_POINT || t == Type.DOUBLE_POINT ? fi.getPointDimensionCount() == 0 : fi.getIndexOptions() == IndexOptions.NONE) continue;
                switch (t) {
                    case INTEGER_POINT: 
                    case LONG_POINT: 
                    case FLOAT_POINT: 
                    case DOUBLE_POINT: 
                    case LEGACY_INTEGER: 
                    case LEGACY_LONG: 
                    case LEGACY_FLOAT: 
                    case LEGACY_DOUBLE: {
                        type = DocValuesType.NUMERIC;
                        break;
                    }
                    case BINARY: {
                        type = DocValuesType.BINARY;
                        break;
                    }
                    case SORTED: {
                        type = DocValuesType.SORTED;
                        break;
                    }
                    case SORTED_SET_BINARY: 
                    case SORTED_SET_INTEGER: 
                    case SORTED_SET_FLOAT: 
                    case SORTED_SET_LONG: 
                    case SORTED_SET_DOUBLE: {
                        type = DocValuesType.SORTED_SET;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            filteredInfos.add(new FieldInfo(fi.name, fi.number, fi.hasVectors(), fi.omitsNorms(), fi.hasPayloads(), fi.getIndexOptions(), type, fi.getDocValuesGen(), fi.attributes(), fi.getPointDimensionCount(), fi.getPointNumBytes()));
        }
        this.fieldInfos = new FieldInfos(filteredInfos.toArray(new FieldInfo[filteredInfos.size()]));
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case INTEGER_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.INT_POINT_PARSER, true);
                }
                case FLOAT_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.FLOAT_POINT_PARSER, true);
                }
                case LONG_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LONG_POINT_PARSER, true);
                }
                case DOUBLE_POINT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.DOUBLE_POINT_PARSER, true);
                }
                case LEGACY_INTEGER: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_INT_PARSER, true);
                }
                case LEGACY_FLOAT: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_FLOAT_PARSER, true);
                }
                case LEGACY_LONG: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_LONG_PARSER, true);
                }
                case LEGACY_DOUBLE: {
                    return FieldCache.DEFAULT.getNumerics(this.in, field, FieldCache.LEGACY_DOUBLE_PARSER, true);
                }
            }
        }
        return super.getNumericDocValues(field);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v == Type.BINARY) {
            return FieldCache.DEFAULT.getTerms(this.in, field, true);
        }
        return this.in.getBinaryDocValues(field);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v == Type.SORTED) {
            return FieldCache.DEFAULT.getTermsIndex(this.in, field);
        }
        return this.in.getSortedDocValues(field);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case SORTED_SET_INTEGER: 
                case SORTED_SET_FLOAT: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT32_TERM_PREFIX);
                }
                case SORTED_SET_LONG: 
                case SORTED_SET_DOUBLE: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, FieldCache.INT64_TERM_PREFIX);
                }
                case SORTED_SET_BINARY: {
                    return FieldCache.DEFAULT.getDocTermOrds(this.in, field, null);
                }
            }
        }
        return this.in.getSortedSetDocValues(field);
    }

    public Bits getDocsWithField(String field) throws IOException {
        Type v = this.getType(field);
        if (v != null) {
            switch (v) {
                case INTEGER_POINT: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.INT_POINT_PARSER);
                }
                case FLOAT_POINT: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.FLOAT_POINT_PARSER);
                }
                case LONG_POINT: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.LONG_POINT_PARSER);
                }
                case DOUBLE_POINT: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.DOUBLE_POINT_PARSER);
                }
                case LEGACY_INTEGER: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.LEGACY_INT_PARSER);
                }
                case LEGACY_FLOAT: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.LEGACY_FLOAT_PARSER);
                }
                case LEGACY_LONG: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.LEGACY_LONG_PARSER);
                }
                case LEGACY_DOUBLE: {
                    return FieldCache.DEFAULT.getDocsWithField(this.in, field, FieldCache.LEGACY_DOUBLE_PARSER);
                }
            }
            return FieldCache.DEFAULT.getDocsWithField(this.in, field, null);
        }
        return this.in.getDocsWithField(field);
    }

    private Type getType(String field) {
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || info.getDocValuesType() == DocValuesType.NONE) {
            return null;
        }
        return this.mapping.get(field);
    }

    public Object getCoreCacheKey() {
        return this.in.getCoreCacheKey();
    }

    public Object getCombinedCoreAndDeletesKey() {
        return this.in.getCombinedCoreAndDeletesKey();
    }

    public String toString() {
        return "Uninverting(" + this.in.toString() + ")";
    }

    public static String[] getUninvertedStats() {
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        String[] info = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            info[i] = entries[i].toString();
        }
        return info;
    }

    public static enum Type {
        INTEGER_POINT,
        LONG_POINT,
        FLOAT_POINT,
        DOUBLE_POINT,
        LEGACY_INTEGER,
        LEGACY_LONG,
        LEGACY_FLOAT,
        LEGACY_DOUBLE,
        BINARY,
        SORTED,
        SORTED_SET_BINARY,
        SORTED_SET_INTEGER,
        SORTED_SET_FLOAT,
        SORTED_SET_LONG,
        SORTED_SET_DOUBLE;

    }

    static class UninvertingDirectoryReader
    extends FilterDirectoryReader {
        final Map<String, Type> mapping;

        public UninvertingDirectoryReader(DirectoryReader in, final Map<String, Type> mapping) throws IOException {
            super(in, new FilterDirectoryReader.SubReaderWrapper(){

                public LeafReader wrap(LeafReader reader) {
                    return new UninvertingReader(reader, mapping);
                }
            });
            this.mapping = mapping;
        }

        protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
            return new UninvertingDirectoryReader(in, this.mapping);
        }
    }
}

