/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.databoard.annotations.Optional;
import org.simantics.db.Resource;
import org.simantics.history.Collector;
import org.simantics.history.HistoryManager;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.experiment.IExperiment;

public final class ChartData {
    @Optional
    public Resource model;
    @Optional
    public Resource run;
    @Optional
    public IExperiment experiment;
    @Optional
    public Datasource datasource;
    @Optional
    public HistoryManager history;
    @Optional
    public Collector collector;
    public AtomicInteger refCount = new AtomicInteger();

    public ChartData(Resource model, Resource run, IExperiment experiment, Datasource datasource, HistoryManager history, Collector collector) {
        this.model = model;
        this.run = run;
        this.experiment = experiment;
        this.datasource = datasource;
        this.history = history;
        this.collector = collector;
    }

    public void readFrom(ChartData other) {
        if (other == null) {
            this.model = null;
            this.run = null;
            this.experiment = null;
            this.datasource = null;
            this.history = null;
            this.collector = null;
            this.refCount = null;
        } else {
            this.model = other.model;
            this.run = other.run;
            this.experiment = other.experiment;
            this.datasource = other.datasource;
            this.history = other.history;
            this.collector = other.collector;
            this.refCount = other.refCount;
        }
    }

    public void dispose() {
        this.model = null;
        this.run = null;
        this.experiment = null;
        this.datasource = null;
        if (this.history != null) {
            this.history.close();
            this.history = null;
        }
    }

    public int reference() {
        AtomicInteger i = this.refCount;
        if (i == null) {
            return 0;
        }
        int result = i.incrementAndGet();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dereference() {
        AtomicInteger i = this.refCount;
        if (i == null) {
            return 0;
        }
        int result = i.decrementAndGet();
        if (result <= 0) {
            AtomicInteger atomicInteger = i;
            synchronized (atomicInteger) {
                i.notifyAll();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotReferenced() throws InterruptedException {
        AtomicInteger i = this.refCount;
        if (i == null) {
            return;
        }
        AtomicInteger atomicInteger = i;
        synchronized (atomicInteger) {
            while (i.get() > 0) {
                i.wait();
            }
        }
    }
}

