/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;

public class MemoryWarningSystem {
    private final Collection<MemoryWarningListener> listeners = new CopyOnWriteArrayList<MemoryWarningListener>();
    private static final MemoryPoolMXBean tenuredGenPool = MemoryWarningSystem.findTenuredGenPool();
    private double percentage = 1.0;
    private ScheduledFuture<?> future;
    private boolean disposed = false;

    public MemoryWarningSystem(int amount, TimeUnit unit) {
        this.future = Simantics.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!MemoryWarningSystem.this.disposed && !MemoryWarningSystem.this.check()) {
                    long bytes = MemoryWarningSystem.this.get();
                    for (MemoryWarningListener listener : MemoryWarningSystem.this.listeners) {
                        listener.memoryLow(bytes);
                    }
                }
            }
        }, 0, amount, unit);
    }

    public long get() {
        return tenuredGenPool.getUsage().getUsed();
    }

    public boolean check() {
        long threshold;
        long max = Runtime.getRuntime().maxMemory();
        long usedMemory = this.get();
        return usedMemory < (threshold = (long)((double)max * this.percentage));
    }

    public long getUsed() {
        return tenuredGenPool.getUsage().getUsed();
    }

    public boolean addListener(MemoryWarningListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(MemoryWarningListener listener) {
        return this.listeners.remove(listener);
    }

    public void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        this.percentage = percentage;
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new IllegalStateException("Could not find tenured space");
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.future.cancel(false);
            this.listeners.clear();
        }
    }

    public static interface MemoryWarningListener {
        public void memoryLow(long var1);
    }
}

