/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.schema;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.meta.HasClassRuleFactory;
import org.simantics.objmap.annotations.meta.HasFieldRuleFactory;
import org.simantics.objmap.annotations.meta.HasMethodRuleFactory;
import org.simantics.objmap.schema.SimpleLinkType;

public class MappingSchemas {
    public static SimpleLinkType fromAnnotations(ReadGraph g, Class<?> clazz) throws DatabaseException, InstantiationException, IllegalAccessException {
        GraphType graphType = clazz.getAnnotation(GraphType.class);
        ArrayList<IMappingRule> rules = new ArrayList<IMappingRule>();
        MappingSchemas.collectRulesFromAnnotations(g, clazz, rules);
        return new SimpleLinkType(g.getResource(graphType.value()), clazz, rules);
    }

    public static void collectRulesFromAnnotations(ReadGraph g, Class<?> clazz, Collection<IMappingRule> rules) throws DatabaseException, InstantiationException, IllegalAccessException {
        Annotation factory;
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            MappingSchemas.collectRulesFromAnnotations(g, superclass, rules);
        }
        Object[] objectArray = clazz.getAnnotations();
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Annotation annotation2 = objectArray[n4];
            HasClassRuleFactory factory2 = annotation2.annotationType().getAnnotation(HasClassRuleFactory.class);
            if (factory2 != null) {
                rules.add(factory2.value().newInstance().create(g, annotation2, clazz));
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredFields();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            Object f = objectArray[n4];
            ((Field)f).setAccessible(true);
            annotationArray = ((AccessibleObject)f).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                factory = annotation.annotationType().getAnnotation(HasFieldRuleFactory.class);
                if (factory != null) {
                    rules.add(factory.value().newInstance().create(g, annotation, (Field)f));
                }
                ++n;
            }
            ++n4;
        }
        objectArray = clazz.getDeclaredMethods();
        n3 = objectArray.length;
        n4 = 0;
        while (n4 < n3) {
            Object m = objectArray[n4];
            ((Method)m).setAccessible(true);
            annotationArray = ((AccessibleObject)m).getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                factory = annotation.annotationType().getAnnotation(HasMethodRuleFactory.class);
                if (factory != null) {
                    rules.add(factory.value().newInstance().create(g, annotation, (Method)m));
                }
                ++n;
            }
            ++n4;
        }
    }
}

