/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.common.processors.AbstractNodeQueryProcessor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.swt.TreeTruncationDecoratorFactory;

public class DefaultLabelDecoratorsProcessor
extends AbstractNodeQueryProcessor<Collection<LabelDecorator>> {
    public Collection<LabelDecorator> query(NodeQueryManager manager, NodeContext context) {
        Collection factories = (Collection)manager.query(context, BuiltinKeys.SELECTED_LABEL_DECORATOR_FACTORIES);
        if (factories.isEmpty()) {
            LabelDecorator truncation = new TreeTruncationDecoratorFactory(1).create(manager, context);
            if (truncation != null) {
                return Collections.singletonList(truncation);
            }
            return Collections.emptyList();
        }
        ArrayList<LabelDecorator> decorators = new ArrayList<LabelDecorator>(factories.size() + 1);
        for (LabelDecoratorFactory f : factories) {
            assert (f != null);
            LabelDecorator decorator = (LabelDecorator)manager.query(context, (NodeContext.PrimitiveQueryKey)new BuiltinKeys.LabelDecoratorKey(f));
            if (decorator == null) continue;
            decorators.add(decorator);
        }
        LabelDecorator truncation = new TreeTruncationDecoratorFactory(1).create(manager, context);
        if (truncation != null) {
            decorators.add(truncation);
        }
        return decorators;
    }

    public String toString() {
        return "LabelDecoratorsProcessor";
    }

    public NodeContext.QueryKey<Collection<LabelDecorator>> getIdentifier() {
        return BuiltinKeys.LABEL_DECORATORS;
    }
}

