/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import gnu.trove.map.hash.THashMap;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.function.All;
import org.simantics.db.layer0.request.ProjectModels;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.VariableProperty;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.request.VariableValueWithBinding;
import org.simantics.db.layer0.scl.SCLDatabaseException;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.ProxySessionRequest;
import org.simantics.db.layer0.variable.ProxyVariableSupport;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.StandardAssertedGraphPropertyVariable;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.ConsoleSCLReportingHandler;
import org.simantics.document.server.DocumentProperties;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.PrimitiveValueVariable;
import org.simantics.document.server.bean.Command;
import org.simantics.document.server.bean.DataDefinition;
import org.simantics.document.server.handler.AbstractEventHandler;
import org.simantics.document.server.handler.AbstractResponseHandler;
import org.simantics.document.server.handler.EventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.CommandResult;
import org.simantics.document.server.io.IConsole;
import org.simantics.document.server.request.ServerSCLHandlerValueRequest;
import org.simantics.document.server.request.ServerSCLValueRequest;
import org.simantics.document.server.serverResponse.Error;
import org.simantics.document.server.serverResponse.ServerResponse;
import org.simantics.document.server.serverResponse.SuccessResponse;
import org.simantics.document.server.state.StateNodeManager;
import org.simantics.document.server.state.StateRealm;
import org.simantics.document.server.state.StateSessionManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.services.CaseInsensitiveComponentFunctionNamingStrategy;
import org.simantics.modeling.services.ComponentNamingStrategy;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.function.FunctionImpl4;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.scl.runtime.tuple.Tuple4;
import org.simantics.scl.runtime.tuple.Tuple5;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.structural2.variables.Connection;
import org.simantics.structural2.variables.StandardProceduralChildVariable;
import org.simantics.structural2.variables.VariableConnectionPointDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Functions {
    private static final Logger LOGGER = LoggerFactory.getLogger(Functions.class);
    @SCLValue(type="VariableMap")
    public static VariableMap primitiveProperties = new VariableMapImpl(){

        private void storePropertyValueAndExceptions(ReadGraph graph, Variable parent, String name, Variable property, Map<String, Variable> map) {
            try {
                Object value = property.getValue(graph);
                map.put(name, (Variable)new ConstantPropertyVariable(parent, name, value, null));
            }
            catch (DatabaseException e) {
                Map<String, DatabaseException> exceptionMap;
                Variable propertyExceptions = map.get("_PropertyValueExceptions");
                if (propertyExceptions == null) {
                    exceptionMap = new TreeMap();
                    propertyExceptions = new ConstantPropertyVariable(parent, "_PropertyValueExceptions", exceptionMap, null);
                    map.put("_PropertyValueExceptions", propertyExceptions);
                } else {
                    try {
                        exceptionMap = (Map)propertyExceptions.getValue(graph);
                    }
                    catch (DatabaseException e1) {
                        org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e1);
                        return;
                    }
                }
                String label = name;
                try {
                    label = property.getLabel(graph);
                }
                catch (DatabaseException databaseException) {}
                exceptionMap.put(label, e);
            }
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            return All.getStandardPropertyDomainPropertyVariableFromValue((ReadGraph)graph, (Variable)context, (String)name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            if (map == null) {
                map = new HashMap<String, Variable>();
            }
            Variable parent = context.getParent(graph);
            DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
            if (parent instanceof StandardProceduralChildVariable) {
                StandardProceduralChildVariable procedural = (StandardProceduralChildVariable)parent;
                for (Variable property : procedural.getProperties(graph)) {
                    PropertyInfo info;
                    if (property instanceof StandardAssertedGraphPropertyVariable) {
                        StandardAssertedGraphPropertyVariable ass = (StandardAssertedGraphPropertyVariable)property;
                        if (!"dataDefinitions".equals(ass.property.name) && !"commands".equals(ass.property.name) && !"pollingFunction".equals(ass.property.name)) continue;
                        this.storePropertyValueAndExceptions(graph, parent, ass.property.name, property, map);
                        continue;
                    }
                    Resource predicate = property.getPossiblePredicateResource(graph);
                    if (predicate == null || !(info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate))).hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) continue;
                    Variable prop = parent.getProperty(graph, predicate);
                    this.storePropertyValueAndExceptions(graph, parent, info.name, prop, map);
                }
            } else {
                Resource parentRes = parent.getRepresents(graph);
                StandardGraphPropertyVariable prop = new StandardGraphPropertyVariable(graph, parent, DOC.Properties_commands);
                this.storePropertyValueAndExceptions(graph, parent, "commands", (Variable)prop, map);
                if (graph.getPossibleObject(parentRes, DOC.Properties_dataDefinitions) != null) {
                    prop = new StandardGraphPropertyVariable(graph, parent, DOC.Properties_dataDefinitions);
                    this.storePropertyValueAndExceptions(graph, parent, "dataDefinitions", (Variable)prop, map);
                }
                DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
                DirectStatements ds = dqs.getDirectPersistentStatements(graph, parentRes);
                for (Statement stm : ds) {
                    Resource predicate = stm.getPredicate();
                    PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
                    if (info.isHasProperty && info.hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) {
                        StandardGraphPropertyVariable prop2 = new StandardGraphPropertyVariable(graph, parent, predicate);
                        this.storePropertyValueAndExceptions(graph, parent, info.name, (Variable)prop2, map);
                        continue;
                    }
                    Resource definition = graph.getPossibleObject(predicate, DOC.Document_definesAttributeRelation);
                    if (definition == null) continue;
                    PropertyInfo info2 = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(definition));
                    StandardGraphPropertyVariable prop3 = new StandardGraphPropertyVariable(graph, parent, definition);
                    map.put(info2.name, (Variable)new PrimitiveValueVariable(parent, info2.name, (Variable)prop3));
                }
            }
            return map;
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap inputSpaceChildren = new VariableMapImpl(){

        private Variable getProxy(ReadGraph graph, Variable context) throws DatabaseException {
            Variable root = Variables.getRootVariable((ReadGraph)graph);
            return new DocumentProxyChildVariable(context, context, root, ">>>");
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            if (">>>".equals(name)) {
                return this.getProxy(graph, context);
            }
            return All.standardChildDomainChildren.getVariable(graph, context, name);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            if ((map = All.standardChildDomainChildren.getVariables(graph, context, map)) == null) {
                map = new THashMap();
            }
            map.put(">>>", this.getProxy(graph, context));
            return map;
        }
    };
    @SCLValue(type="AbstractEventHandler")
    public static AbstractEventHandler emptyEvent = new AbstractEventHandler(){

        public CommandResult handle(CommandContext context) {
            return null;
        }
    };

    public static DocumentProperties primitiveProperties() throws DatabaseException {
        return new StandardDocumentProperties();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable input(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable session = (Variable)graph.syncRequest((Read)new ProxySessionRequest(context));
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        String uri = (String)session.getPossiblePropertyValue(graph, DOC.Session_inputURI);
        if (uri == null) {
            return session;
        }
        return Variables.getVariable((ReadGraph)graph, (String)uri);
    }

    public static Variable stateVariable(ReadGraph graph, Variable self) throws DatabaseException {
        Variable session = (Variable)graph.syncRequest((Read)new ProxySessionRequest(self));
        if (session == null) {
            throw new DatabaseException("No state for " + self.getURI(graph));
        }
        return session.getPossibleChild(graph, "__scl__");
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable state(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable session = (Variable)graph.syncRequest((Read)new ProxySessionRequest(context));
        if (session == null) {
            throw new DatabaseException("No state for " + context.getURI(graph));
        }
        return session.getPossibleChild(graph, "__scl__");
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable icstate(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable session = (Variable)graph.syncRequest((Read)new ProxySessionRequest(context));
        return session.getPossibleChild(graph, "__icstate__");
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable session(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new ProxySessionRequest(context));
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable experiment(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        IExperiment exp;
        Variable var = Functions.input(graph, converter, context);
        SimulationResource SR = SimulationResource.getInstance((ReadGraph)graph);
        while (var != null && !graph.isInstanceOf(var.getRepresents(graph), SR.Run)) {
            var = var.getParent(graph);
        }
        if (var != null && (exp = Functions.getExperiment(graph, var)) == null) {
            return null;
        }
        return var;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Variable")
    public static Variable model(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        Variable var = Functions.input(graph, converter, context);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        while (var != null && !graph.isInstanceOf(var.getRepresents(graph), MOD.StructuralModel)) {
            var = var.getParent(graph);
        }
        return var;
    }

    private static Collection<Variable> getBroadcasted(ReadGraph graph, Variable target) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        Variable broadcasted = target.getPossibleProperty(graph, DOC.Relations_broadcasted);
        if (broadcasted != null) {
            result.add(broadcasted);
        }
        for (Variable child : DocumentServerUtils.getChildrenInOrdinalOrder(graph, target)) {
            result.addAll(Functions.getBroadcasted(graph, child));
        }
        return result;
    }

    private static List<Command> getCommands(ReadGraph graph, Collection<Variable> commandVariables, String trigger, CommandContext constants, boolean broadcast) throws DatabaseException {
        if (commandVariables.isEmpty()) {
            return Collections.emptyList();
        }
        String t = trigger;
        TreeMap<Integer, List<Command>> sequences = new TreeMap<Integer, List<Command>>();
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        int count = 0;
        for (Variable c : commandVariables) {
            String forbiddenKey;
            String requiredKey;
            Integer ordinal;
            Boolean enabled;
            Variable target;
            Connection conn;
            Variable targetConnectionPoint;
            if (trigger == null) {
                t = c.getName(graph);
            }
            if ((targetConnectionPoint = DocumentServerUtils.getPossibleCommandTriggerConnectionPoint(graph, c, conn = (Connection)c.getValue(graph))) == null || (target = targetConnectionPoint.getParent(graph)) == null || (enabled = (Boolean)target.getPossiblePropertyValue(graph, DOC.Properties_exists, (Binding)Bindings.BOOLEAN)) != null && !enabled.booleanValue()) continue;
            if (broadcast) {
                ordinal = ++count;
            } else {
                ordinal = 1;
                try {
                    String o = (String)c.getPossiblePropertyValue(graph, "ordinal");
                    if (o != null) {
                        ordinal = Integer.parseInt(o);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            String constantKey = (String)target.getPossiblePropertyValue(graph, "constantKey");
            String constantValue = (String)target.getPossiblePropertyValue(graph, "constantValue");
            CommandContextMutable newConstants = (CommandContextMutable)constants;
            if (constantKey != null && constantValue != null && !constantKey.isEmpty()) {
                newConstants = new CommandContextImpl().merge(constants);
                newConstants.putString(constantKey, constantValue);
            }
            if ((requiredKey = (String)target.getPossiblePropertyValue(graph, "requiredKey")) != null && !requiredKey.isEmpty()) {
                if (newConstants == constants) {
                    newConstants = new CommandContextImpl().merge(constants);
                }
                newConstants.putRow("!!!requiredKeys", Collections.singletonList(requiredKey));
            }
            if ((forbiddenKey = (String)target.getPossiblePropertyValue(graph, "forbiddenKey")) != null && !forbiddenKey.isEmpty()) {
                if (newConstants == constants) {
                    newConstants = new CommandContextImpl().merge(constants);
                }
                newConstants.putRow("!!!forbiddenKeys", Collections.singletonList(forbiddenKey));
            }
            if (DOC.Relations_broadcast.equals(targetConnectionPoint.getPredicateResource(graph))) {
                List<Command> broadcastCommands = Functions.getCommands(graph, Functions.getBroadcasted(graph, target), t, (CommandContext)newConstants, true);
                sequences.put(ordinal, broadcastCommands);
                continue;
            }
            Command command = new Command(DocumentServerUtils.getId(graph, target), t, targetConnectionPoint.getName(graph), (CommandContext)newConstants);
            sequences.put(ordinal, Collections.singletonList(command));
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (List commandList : sequences.values()) {
            for (Command command : commandList) {
                commands.add(command);
            }
        }
        return commands;
    }

    public static List<Command> commandList(ReadGraph graph, Variable variable) throws DatabaseException {
        return Functions.getCommands(graph, DocumentServerUtils.getTriggerCommands(graph, variable.getParent(graph)), null, (CommandContext)new CommandContextImpl(), false);
    }

    public static List<DataDefinition> dataDefinitions(ReadGraph graph, Variable variable) throws DatabaseException {
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        ArrayList<DataDefinition> dataDefinitions = new ArrayList<DataDefinition>();
        for (Variable dataDefinitionRelation : DocumentServerUtils.getDataDefinitions(graph, variable.getParent(graph))) {
            Connection dataDefinitionConnection;
            Collection<Variable> dataDefinitionProviders = DocumentServerUtils.getPossibleOtherConnectionPoints(graph, dataDefinitionRelation, dataDefinitionConnection = (Connection)dataDefinitionRelation.getValue(graph));
            if (dataDefinitionProviders == null) continue;
            for (Variable dataDefinitionProvider : dataDefinitionProviders) {
                Connection dataConnection;
                Variable dataRelation;
                Variable dataConnectionPoint;
                Collection<Variable> dataCollection;
                Variable dataDefinition = dataDefinitionProvider.getParent(graph);
                if (dataDefinition == null || (dataCollection = DocumentServerUtils.getDataRelations(graph, dataDefinition)).size() != 1 || (dataConnectionPoint = DocumentServerUtils.getPossibleOtherConnectionPoint(graph, dataRelation = dataCollection.iterator().next(), dataConnection = (Connection)dataRelation.getValue(graph))) == null) continue;
                Variable data = dataConnectionPoint.getParent(graph);
                Resource type = dataDefinition.getPossibleType(graph, DOC.Components_Component);
                if (graph.isInheritedFrom(type, DOC.Components_DefVar)) {
                    String sourceProperty = (String)dataDefinition.getPropertyValue(graph, DOC.Properties_source, (Binding)Bindings.STRING);
                    String targetProperty = (String)dataDefinition.getPropertyValue(graph, DOC.Properties_target, (Binding)Bindings.STRING);
                    dataDefinitions.add(new DataDefinition(DocumentServerUtils.getId(graph, data), sourceProperty, targetProperty));
                    continue;
                }
                if (!graph.isInheritedFrom(type, DOC.Components_DefVars)) continue;
                List<String> sourcesProperty = Functions.toList(dataDefinition.getPropertyValue(graph, DOC.Properties_sources), String.class);
                List<String> targetsProperty = Functions.toList(dataDefinition.getPropertyValue(graph, DOC.Properties_targets), String.class);
                int i = 0;
                while (i < Math.min(sourcesProperty.size(), targetsProperty.size())) {
                    dataDefinitions.add(new DataDefinition(DocumentServerUtils.getId(graph, data), sourcesProperty.get(i), targetsProperty.get(i)));
                    ++i;
                }
            }
        }
        return dataDefinitions;
    }

    private static <T> List<T> toList(Object o, Class<T> c) {
        ArrayList<Object> result = null;
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Object[]) {
            result = new ArrayList<Object>(((Object[])o).length);
            Object[] objectArray = (Object[])o;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                result.add(item);
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static AbstractEventHandler emptyOnClick(ReadGraph graph) throws DatabaseException {
        return new EventHandler(){

            @Override
            public ServerResponse handle(ReadGraph graph, CommandContext parameters) throws DatabaseException {
                return null;
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler writeEventHandler(ReadGraph graph, final Variable variable, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            public CommandResult handle(final CommandContext parameters) {
                final SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    String result = (String)session.sync((WriteInterface)new WriteResultRequest<String>(){

                        public String perform(WriteGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                            try {
                                FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                                    public String apply(String key) {
                                        return parameters.getString(key);
                                    }
                                };
                                String response = (String)fn.apply((Object)variable, (Object)pf);
                                if (response instanceof String) {
                                    String string = response;
                                    return string;
                                }
                                return null;
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"reportingHandler", oldPrinter);
                            }
                        }
                    });
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler readEventHandler(ReadGraph graph, final Variable variable, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            public CommandResult handle(final CommandContext parameters) {
                final SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    String result = (String)session.sync((ReadInterface)new UniqueRead<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                            try {
                                FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                                    public String apply(String key) {
                                        return parameters.getString(key);
                                    }
                                };
                                String response = (String)fn.apply((Object)variable, (Object)pf);
                                if (response instanceof String) {
                                    String string = response;
                                    return string;
                                }
                                return null;
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"reportingHandler", oldPrinter);
                            }
                        }
                    });
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler readEventHandler2(ReadGraph graph, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            public CommandResult handle(final CommandContext parameters) {
                final SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    CommandResult result = (CommandResult)session.sync((ReadInterface)new UniqueRead<CommandResult>(){

                        public CommandResult perform(ReadGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                            try {
                                Object response = fn.apply((Object)parameters);
                                if (response instanceof CommandResult) {
                                    CommandResult commandResult = (CommandResult)response;
                                    return commandResult;
                                }
                                return null;
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"reportingHandler", oldPrinter);
                            }
                        }
                    });
                    return result;
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    public static AbstractEventHandler responseHandler(ReadGraph graph, final Variable self, String function) throws DatabaseException {
        final Variable anyFunction = self.browse(graph, ".#" + function);
        if (anyFunction == null) {
            return null;
        }
        final List<TCon> effects = ServerSCLHandlerValueRequest.getEffects(graph, anyFunction);
        final Function1 fn = (Function1)anyFunction.getValue(graph);
        final Session session = graph.getSession();
        return new AbstractResponseHandler(fn){

            private String formatError(RequestProcessor proc, final Throwable t) {
                try {
                    return (String)proc.syncRequest((Read)new UniqueRead<String>(){

                        public String perform(ReadGraph graph) throws DatabaseException {
                            Variable proxy = ProxyVariables.proxyVariableRoot((ReadGraph)graph, (Variable)anyFunction);
                            String uri2 = proxy.getURI(graph);
                            String uri = self.getParent(graph).getURI(graph);
                            String path = uri.substring(uri2.length());
                            String expr = (String)anyFunction.getPossiblePropertyValue(graph, "expression");
                            StringBuilder message = new StringBuilder();
                            message.append("Handler execution failed\n");
                            message.append(" handler=" + path + "\n");
                            message.append(" expression=" + expr + "\n");
                            message.append(" message=" + t.getMessage() + "\n");
                            StringWriter sw = new StringWriter();
                            t.printStackTrace(new PrintWriter(sw));
                            message.append(" stack trace=" + sw);
                            return message.toString();
                        }
                    });
                }
                catch (DatabaseException e) {
                    return e.getMessage();
                }
            }

            public CommandResult handle(final CommandContext parameters) {
                IConsole console = (IConsole)parameters.getValue("__console__");
                final ConsoleSCLReportingHandler printer = console != null ? new ConsoleSCLReportingHandler(console) : (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    Object result = null;
                    if (effects.contains(Types.WRITE_GRAPH)) {
                        result = session.syncRequest((WriteResult)new WriteResultRequest<Object>(){

                            public Object perform(WriteGraph graph) throws DatabaseException {
                                SCLContext sclContext = SCLContext.getCurrent();
                                Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                                Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                                try {
                                    Object object = fn.apply((Object)parameters);
                                    return object;
                                }
                                finally {
                                    sclContext.put((Object)"graph", oldGraph);
                                    sclContext.put((Object)"reportingHandler", oldPrinter);
                                }
                            }
                        });
                    } else if (effects.contains(Types.READ_GRAPH)) {
                        result = session.sync((ReadInterface)new UniqueRead<Object>(){

                            public Object perform(ReadGraph graph) throws DatabaseException {
                                SCLContext sclContext = SCLContext.getCurrent();
                                Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                                Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                                try {
                                    Object object = fn.apply((Object)parameters);
                                    return object;
                                }
                                finally {
                                    sclContext.put((Object)"graph", oldGraph);
                                    sclContext.put((Object)"reportingHandler", oldPrinter);
                                }
                            }
                        });
                    } else {
                        SCLContext sclContext = SCLContext.getCurrent();
                        Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                        try {
                            result = fn.apply((Object)parameters);
                        }
                        finally {
                            sclContext.put((Object)"reportingHandler", oldPrinter);
                        }
                    }
                    if (result instanceof Error) {
                        return (CommandResult)result;
                    }
                    if (result instanceof CommandResult) {
                        return (CommandResult)result;
                    }
                    CommandContextImpl assignments = new CommandContextImpl();
                    assignments.putValue("result", result);
                    return new ServerResponse(200, "", (CommandContextMutable)assignments);
                }
                catch (Throwable e) {
                    return new Error(this.formatError((RequestProcessor)Simantics.getSession(), e));
                }
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler writeEventHandler2(ReadGraph graph, final Function fn) {
        final Session session = graph.getSession();
        return new AbstractEventHandler(){

            public CommandResult handle(final CommandContext parameters) {
                final SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    CommandResult result = (CommandResult)session.syncRequest((WriteResult)new WriteResultRequest<CommandResult>(){

                        public CommandResult perform(WriteGraph graph) throws DatabaseException {
                            SCLContext sclContext = SCLContext.getCurrent();
                            Object oldGraph = sclContext.put((Object)"graph", (Object)graph);
                            Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                            try {
                                Object response = fn.apply((Object)parameters);
                                if (response instanceof CommandResult) {
                                    CommandResult commandResult = (CommandResult)response;
                                    return commandResult;
                                }
                                return null;
                            }
                            finally {
                                sclContext.put((Object)"graph", oldGraph);
                                sclContext.put((Object)"reportingHandler", oldPrinter);
                            }
                        }
                    });
                    return result;
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler eventHandler2(ReadGraph graph, final Function fn) {
        return new AbstractEventHandler(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public CommandResult handle(CommandContext parameters) {
                SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    SCLContext sclContext = SCLContext.getCurrent();
                    Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                    try {
                        Object response = fn.apply((Object)parameters);
                        if (!(response instanceof CommandResult)) return null;
                        CommandResult commandResult = (CommandResult)response;
                        return commandResult;
                    }
                    finally {
                        sclContext.put((Object)"reportingHandler", oldPrinter);
                    }
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @Deprecated
    public static AbstractEventHandler eventHandler(ReadGraph graph, final Function fn) {
        return new AbstractEventHandler(){

            public CommandResult handle(final CommandContext parameters) {
                SCLReportingHandler printer = (SCLReportingHandler)SCLContext.getCurrent().get((Object)"reportingHandler");
                try {
                    String result = "";
                    SCLContext sclContext = SCLContext.getCurrent();
                    Object oldPrinter = sclContext.put((Object)"reportingHandler", (Object)printer);
                    try {
                        FunctionImpl1<String, String> pf = new FunctionImpl1<String, String>(){

                            public String apply(String key) {
                                return parameters.getString(key);
                            }
                        };
                        String response = (String)fn.apply((Object)pf);
                        if (response instanceof String) {
                            result = response;
                        }
                    }
                    finally {
                        sclContext.put((Object)"reportingHandler", oldPrinter);
                    }
                    return new SuccessResponse(result);
                }
                catch (Throwable e) {
                    org.simantics.db.common.utils.Logger.defaultLogError((Throwable)e);
                    return new Error(e.getMessage());
                }
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object sclValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ServerSCLValueRequest.compileAndEvaluate(graph, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object sclHandlerValue(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return ServerSCLHandlerValueRequest.compileAndEvaluate(graph, context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Resource -> ComponentNamingStrategy")
    public static ComponentNamingStrategy componentNamingStrategy(ReadGraph graph, Resource converter, Resource context) throws DatabaseException {
        return Functions.createComponentNamingStrategy(graph);
    }

    public static CaseInsensitiveComponentFunctionNamingStrategy createComponentNamingStrategy(ReadGraph graph) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        final Function dependencies = (Function)graph.syncRequest((Read)new Adapter(L0X.DependencyResources, Function.class), (Listener)TransientCacheListener.instance());
        FunctionImpl4<ReadGraph, Resource, String, Integer, List<Map<String, Object>>> moduleNameFunction = new FunctionImpl4<ReadGraph, Resource, String, Integer, List<Map<String, Object>>>(){

            public Object apply(ReadGraph p0, Resource p1, String p2) {
                return this.apply(p0, p1, p2);
            }

            public List<Map<String, Object>> apply(ReadGraph graph, Resource model, String search, Integer maxResults) {
                return (List)dependencies.apply((Object)graph, (Object)model, (Object)search, (Object)maxResults);
            }
        };
        return new CaseInsensitiveComponentFunctionNamingStrategy("%s%02d", (Function)moduleNameFunction);
    }

    public static IExperiment getExperiment(ReadGraph graph, Variable variable) throws DatabaseException {
        IExperimentManager expMan;
        if (variable == null) {
            return null;
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Variable var = variable;
        Resource represents = var.getRepresents(graph);
        Resource activeRun = null;
        if (represents != null && graph.isInstanceOf(represents, SIMU.Run)) {
            activeRun = represents;
        }
        IProject project = Simantics.peekProject();
        if (activeRun != null && project != null && (expMan = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER)) != null) {
            return expMan.getExperiment(NameUtils.getSafeName((ReadGraph)graph, (Resource)activeRun));
        }
        return null;
    }

    public static CommandContextMutable putTuple(CommandContextMutable context, String key, Object tuple) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (tuple instanceof Tuple) {
            Collections.addAll(list, ((Tuple)tuple).toArray());
        } else {
            list.add(tuple);
        }
        context.putRow(key, list);
        return context;
    }

    public static List<Object> getTuples(CommandContext context, String key) {
        List rows = context.getRows(key);
        ArrayList<Object> tuples = new ArrayList<Object>();
        if (rows != null) {
            for (List row : rows) {
                switch (row.size()) {
                    case 0: {
                        tuples.add(Tuple0.INSTANCE);
                        break;
                    }
                    case 1: {
                        tuples.add(row.get(1));
                        break;
                    }
                    case 2: {
                        tuples.add(new Tuple2(row.get(0), row.get(1)));
                        break;
                    }
                    case 3: {
                        tuples.add(new Tuple3(row.get(0), row.get(1), row.get(2)));
                        break;
                    }
                    case 4: {
                        tuples.add(new Tuple4(row.get(0), row.get(1), row.get(2), row.get(3)));
                        break;
                    }
                    case 5: {
                        tuples.add(new Tuple5(row.get(0), row.get(1), row.get(2), row.get(3), row.get(4)));
                    }
                }
            }
        }
        return tuples;
    }

    public static String printContext(CommandContext context) {
        return context.toString();
    }

    public static String sclStateKey(ReadGraph graph, Variable base, Variable self, String ref) throws DatabaseException {
        String baseURI = base.getURI(graph);
        String selfURI = self.getURI(graph);
        String prefix = selfURI.substring(0, selfURI.indexOf(">>>"));
        String suffix = selfURI.substring(selfURI.lastIndexOf("<<<") + "<<<".length());
        String stripped = String.valueOf(prefix) + suffix;
        String relative = Variables.getRelativeRVI((String)baseURI, (String)stripped);
        return Variables.getRVI((String)relative, (String)ref);
    }

    public static Variable sclStateVariable(ReadGraph graph, Variable base, Variable self, String ref) throws DatabaseException {
        String id = Functions.sclStateKey(graph, base, self, ref);
        Variable sclVar = base.getPossibleChild(graph, "__scl__");
        if (sclVar == null) {
            return null;
        }
        return sclVar.getPossibleProperty(graph, id);
    }

    public static Object sclStateValueOrDefault(ReadGraph graph, Variable base, Variable self, String ref, Object defaultValue) throws DatabaseException {
        Variable stateVariable = Functions.sclStateVariable(graph, base, self, ref);
        if (stateVariable != null) {
            return stateVariable.getValue(graph);
        }
        return defaultValue;
    }

    public static void setSclStateValue(WriteGraph graph, Variable base, Variable self, String ref, Object value) throws DatabaseException {
        String id = Functions.sclStateKey((ReadGraph)graph, base, self, ref);
        StateRealm realm = (StateRealm)StateSessionManager.getInstance().getOrCreateRealm((ReadGraph)graph, String.valueOf(base.getURI((ReadGraph)graph)) + "/__scl__");
        StateNodeManager nodeManager = (StateNodeManager)realm.getNodeManager();
        nodeManager.setState(id, value);
    }

    public static Object projectComponentState(ReadGraph graph, Variable self, String ref, Object defaultValue) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        Variable component = self.getParent(graph);
        Variable projectVariable = Variables.getVariable((ReadGraph)graph, (Resource)project);
        return Functions.sclStateValueOrDefault(graph, projectVariable, component, ref, defaultValue);
    }

    public static void setProjectComponentState(WriteGraph graph, Variable self, String ref, Object value) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        Variable component = self.getParent((ReadGraph)graph);
        Variable projectVariable = Variables.getVariable((ReadGraph)graph, (Resource)project);
        Functions.setSclStateValue(graph, projectVariable, component, ref, value);
    }

    private static Type getSCLType(Object value) throws DatabaseException {
        Binding b = Bindings.getBindingUnchecked(value.getClass());
        Datatype t = b.type();
        if (Datatypes.STRING.equals((Object)t)) {
            return Types.STRING;
        }
        if (Datatypes.DOUBLE.equals((Object)t)) {
            return Types.DOUBLE;
        }
        throw new DatabaseException("Type not supported");
    }

    public static List<Variable> documentModelContribution(ReadGraph graph, Resource doc) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Resource model : (Collection)graph.syncRequest((Read)new ProjectModels(project))) {
            result.add(Variables.getVariable((ReadGraph)graph, (Resource)model));
        }
        return result;
    }

    public static String documentModelContributionLabel(ReadGraph graph, Variable var) throws DatabaseException {
        return var.getName(graph);
    }

    public static Object getPropertyValueCached(ReadGraph graph, Variable variable, String name, Binding binding) throws DatabaseException {
        Variable property = (Variable)graph.syncRequest((Read)new VariableProperty(variable, name));
        return graph.syncRequest((Read)new VariableValueWithBinding(property, binding));
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> Boolean")
    public static boolean pathExists(ReadGraph graph, Resource converter, Variable context) throws DatabaseException {
        return (Boolean)graph.syncRequest((Read)new PathExistsRequest(context));
    }

    public static String compileDocumentSCLValueExpression(ReadGraph graph, Variable context) {
        try {
            ServerSCLValueRequest.validate(graph, context);
            return "";
        }
        catch (Exception e) {
            return Functions.resolveIssueMessage(e);
        }
    }

    private static String resolveIssueMessage(Exception e) {
        if (e instanceof ImportFailureException) {
            return "";
        }
        if (e.getCause() != null && e.getCause() instanceof ImportFailureException) {
            return "";
        }
        if (e instanceof SCLDatabaseException) {
            SCLDatabaseException ee = (SCLDatabaseException)e;
            return ee.getMessage();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("", (Throwable)e);
        }
        return e.getMessage();
    }

    static class DocumentPropertyKeys
    extends ResourceRead<List<String>> {
        protected DocumentPropertyKeys(Resource resource) {
            super(resource);
        }

        public List<String> perform(ReadGraph graph) throws DatabaseException {
            ArrayList<String> result = new ArrayList<String>();
            DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
            if (graph.hasStatement(this.resource, DOC.Properties_commands)) {
                result.add("commands");
            }
            if (graph.hasStatement(this.resource, DOC.Properties_dataDefinitions)) {
                result.add("dataDefinitions");
            }
            DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            DirectStatements ds = dqs.getDirectPersistentStatements(graph, this.resource);
            for (Statement stm : ds) {
                Resource predicate = stm.getPredicate();
                PropertyInfo info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate));
                if (info.isHasProperty && info.hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) {
                    result.add(info.name);
                    continue;
                }
                Resource definition = graph.getPossibleObject(predicate, DOC.Document_definesAttributeRelation);
                if (definition == null) continue;
                PropertyInfo info2 = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(definition));
                result.add(info2.name);
            }
            return result;
        }
    }

    static class DocumentProxyChildVariable
    extends ProxyChildVariable
    implements ProxyVariableSupport {
        public DocumentProxyChildVariable(Variable base, Variable parent, Variable other, String name) {
            super(base, parent, other, name);
        }

        public Variable create(Variable base, Variable parent, Variable other, String name) {
            return new DocumentProxyChildVariable(base, parent, other, name);
        }

        public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
            if ("<<<".equals(name)) {
                if (this.other instanceof ProxyChildVariable) {
                    return super.getPossibleChild(graph, name);
                }
                return ProxyVariables.tryToOwnRenamed((ReadGraph)graph, (Variable)this, (Variable)this.base, (String)"<<<");
            }
            return super.getPossibleChild(graph, name);
        }

        public Variable attachTo(ReadGraph graph, Variable parent) {
            return this.attachToRenamed(graph, parent, this.name);
        }

        public Variable attachToRenamed(ReadGraph graph, Variable parent, String name) {
            if (this.parent.equals(this.base)) {
                return new DocumentProxyChildVariable(parent, parent, this.other, name);
            }
            return new DocumentProxyChildVariable(this.base, parent, this.other, name);
        }
    }

    public static class ParentExistsRequest
    extends VariableRead<Boolean> {
        public ParentExistsRequest(Variable parent) {
            super(parent);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            Variable existsProperty = this.variable.getPossibleProperty(graph, "exists");
            if (existsProperty == null) {
                return true;
            }
            Boolean exists = (Boolean)existsProperty.getPossibleValue(graph, (Binding)Bindings.BOOLEAN);
            if (exists == null || !exists.booleanValue()) {
                return false;
            }
            return (Boolean)graph.syncRequest((Read)new ParentExistsRequest(this.variable.getParent(graph)));
        }
    }

    public static class PathExistsRequest
    extends VariableRead<Boolean> {
        public PathExistsRequest(Variable variable) {
            super(variable);
        }

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            Variable widget = this.variable.getParent(graph);
            Boolean exists = (Boolean)widget.getPossiblePropertyValue(graph, "exists");
            if (exists == null || !exists.booleanValue()) {
                return false;
            }
            if (!((Boolean)graph.syncRequest((Read)new ParentExistsRequest(widget.getParent(graph)))).booleanValue()) {
                return false;
            }
            DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
            Collection cps = widget.getProperties(graph, "http://www.simantics.org/Documentation-1.2/Relations/parentRelation");
            for (Variable cp : cps) {
                Variable parentWidget;
                Variable parentCp;
                Variable parentWidget2;
                Connection conn;
                Variable otherCp = DocumentServerUtils.getPossibleChildConnectionPoint(graph, cp, conn = (Connection)cp.getValue(graph));
                if (!(otherCp != null ? (Boolean)(parentWidget2 = otherCp.getParent(graph)).getPropertyValue(graph, "pathExists") != false : (parentCp = (Variable)graph.sync((ReadInterface)new BinaryRead<Variable, Connection, Variable>(widget, conn){

                    public Variable perform(ReadGraph graph) throws DatabaseException {
                        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
                        Collection descs = ((Connection)this.parameter2).getConnection2().getConnectionPointDescriptors(graph, (Variable)this.parameter, null);
                        for (VariableConnectionPointDescriptor desc : descs) {
                            if (!DOC.Relations_partN.equals(desc.getConnectionPointResource(graph))) continue;
                            return desc.getVariable(graph);
                        }
                        return null;
                    }
                })) != null && (Boolean)(parentWidget = parentCp.getParent(graph)).getPropertyValue(graph, "pathExists") != false)) continue;
                return true;
            }
            Resource type = widget.getType(graph);
            if (!(graph.isInheritedFrom(type, DOC.Components_ParentlessComponent) || graph.isInheritedFrom(type, DOC.DocumentComponent) && cps.isEmpty())) {
                return false;
            }
            return true;
        }
    }

    static class StandardDocumentProperties
    implements DocumentProperties {
        StandardDocumentProperties() {
        }

        @Override
        public Collection<String> getKeys(ReadGraph graph, Variable parent) throws DatabaseException {
            if (parent instanceof StandardProceduralChildVariable) {
                StandardProceduralChildVariable procedural = (StandardProceduralChildVariable)parent;
                ArrayList<String> result = new ArrayList<String>();
                for (Variable property : procedural.getProperties(graph)) {
                    PropertyInfo info;
                    if (property instanceof StandardAssertedGraphPropertyVariable) {
                        StandardAssertedGraphPropertyVariable ass = (StandardAssertedGraphPropertyVariable)property;
                        if (!"dataDefinitions".equals(ass.property.name) && !"commands".equals(ass.property.name) && !"pollingFunction".equals(ass.property.name)) continue;
                        result.add(ass.property.name);
                        continue;
                    }
                    Resource predicate = property.getPossiblePredicateResource(graph);
                    if (predicate == null || !(info = (PropertyInfo)graph.syncRequest((Read)new PropertyInfoRequest(predicate))).hasClassification("http://www.simantics.org/Documentation-1.2/Document/AttributeRelation")) continue;
                    result.add(info.name);
                }
                return result;
            }
            Resource parentRes = parent.getRepresents(graph);
            return (Collection)graph.syncRequest((Read)new DocumentPropertyKeys(parentRes), (AsyncProcedure)TransientCacheAsyncListener.instance());
        }

        @Override
        public Object getValue(ReadGraph graph, Variable context, String key) throws DatabaseException {
            return context.getPropertyValue(graph, key);
        }
    }
}

